/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.LinkedHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.EnumHelper;

public abstract class RequestHelper {
    public static String arrayToString(Long[] list) {
        StringBuilder strBuilder = new StringBuilder("[");
        for (Long id : list) {
            strBuilder.append(id).append(",");
        }
        strBuilder.delete(strBuilder.length() - 1, strBuilder.length()).append("]");
        return strBuilder.toString();
    }

    public static Cookie getCookie(ServletRequest servletRequest, String name) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getCookieValue(ServletRequest servletRequest, String name) {
        Cookie cookie = RequestHelper.getCookie(servletRequest, name);
        return cookie == null ? null : cookie.getValue();
    }

    public static String getPathPrefix(HttpServletRequest request) {
        String pathPrefix = (String)request.getSession().getAttribute("pathPrefix");
        if (pathPrefix == null) {
            pathPrefix = request.getRequestURI().contains("/member") ? "/do/member" : "/do/admin";
        }
        return pathPrefix;
    }

    public static boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
    }

    public static boolean isFromMenu(HttpServletRequest request) {
        return "true".equals(request.getParameter("fromMenu"));
    }

    public static boolean isGet(HttpServletRequest request) {
        return !RequestHelper.isValidation(request) && RequestHelper.isMethod(request, "GET");
    }

    public static boolean isPost(HttpServletRequest request) {
        return !RequestHelper.isValidation(request) && RequestHelper.isMethod(request, "POST");
    }

    public static boolean isPosWeb(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null && Boolean.TRUE.equals(session.getAttribute("isPosWeb"))) {
            return true;
        }
        return request.getRequestURI().contains("/posweb/");
    }

    public static boolean isValidation(HttpServletRequest request) {
        return "true".equals(request.getParameter("validation"));
    }

    public static boolean isWebService(HttpServletRequest request) {
        return request.getRequestURI().contains("/services/");
    }

    public static <E extends Enum<?>> void storeEnum(HttpServletRequest request, Class<E> enumType) {
        String name = ClassHelper.getClassName(enumType);
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        RequestHelper.storeEnum(request, enumType, name);
    }

    public static <E extends Enum<?>> void storeEnum(HttpServletRequest request, Class<E> enumType, String key) {
        Enum[] values = EnumHelper.values(enumType);
        request.setAttribute(key, (Object)values);
    }

    public static <E extends Enum<?>> void storeEnumMap(HttpServletRequest request, Class<E> enumType, String key) {
        Enum[] values = EnumHelper.values(enumType);
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : values) {
            map.put(e.name(), e);
        }
        request.setAttribute(key, map);
    }

    private static boolean isMethod(HttpServletRequest request, String method) {
        try {
            return request.getMethod().equalsIgnoreCase(method);
        }
        catch (Exception e) {
            return false;
        }
    }
}

