/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.JSONBuilder;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ResponseHelper {
    private MessageHelper messageHelper;
    private SettingsService settingsService;

    public Cookie addRootCookie(HttpServletRequest request, HttpServletResponse response, String name, Object value) {
        Cookie cookie = new Cookie(name, value == null ? "" : value.toString());
        cookie.setPath(request.getContextPath());
        response.addCookie(cookie);
        return cookie;
    }

    public void setDownload(HttpServletResponse response, String fileName) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\";");
        response.setHeader("Pragma", "Public");
        response.setHeader("Cache-Control", "");
    }

    public void setEncoding(HttpServletResponse response) {
        response.setCharacterEncoding(this.settingsService.getLocalSettings().getCharset());
    }

    public void setInline(HttpServletResponse response) {
        response.setHeader("Content-Disposition", "inline");
    }

    public void setLoginCookies(HttpServletRequest request, HttpServletResponse response, Entity entity) {
        Long groupId = null;
        Long groupFilterId = null;
        if (entity instanceof Group) {
            groupId = entity.getId();
        } else if (entity instanceof GroupFilter) {
            groupFilterId = entity.getId();
        }
        this.addRootCookie(request, response, "groupId", groupId);
        this.addRootCookie(request, response, "groupFilterId", groupFilterId);
    }

    public void setMessageHelper(MessageHelper messageHelper) {
        this.messageHelper = messageHelper;
    }

    public void setNoCache(HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store,max-age=0");
        response.setDateHeader("Expires", 1L);
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void setTextNoCache(HttpServletResponse response) {
        response.setContentType("text/plain");
        this.setEncoding(response);
        this.setNoCache(response);
    }

    public void setXmlNoCache(HttpServletResponse response) {
        response.setContentType("text/xml");
        this.setEncoding(response);
        this.setNoCache(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(HttpServletResponse response, File file) throws IOException {
        if (file.exists()) {
            response.setContentLength((int)file.length());
            response.setDateHeader("Last-Modified", file.lastModified());
            FileInputStream in = new FileInputStream(file);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public void writeJSON(HttpServletResponse response, JSONBuilder json) {
        try {
            PrintWriter out = response.getWriter();
            out.print("{\"result\":");
            json.write(out);
            out.print("}");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error writing JSON string", e);
        }
    }

    public void writeJSON(HttpServletResponse response, String json) {
        try {
            response.getWriter().print("{\"result\":" + json + "}");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error writing JSON string", e);
        }
    }

    public void writeStatus(HttpServletResponse response, Object status, Map<String, ?> fields) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version='1.0' encoding='").append(this.settingsService.getLocalSettings().getCharset()).append("'?>");
        sb.append("<status value='").append(status).append("'>");
        if (fields != null && !fields.isEmpty()) {
            for (Map.Entry<String, ?> entry : fields.entrySet()) {
                String tag = entry.getKey();
                sb.append('<').append(tag).append("><![CDATA[");
                sb.append(entry.getValue());
                sb.append("]]></").append(tag).append('>');
            }
        }
        sb.append("</status>");
        this.setXmlNoCache(response);
        try {
            response.getWriter().print(sb.toString());
        }
        catch (IOException e1) {
            throw new IllegalStateException("Error writing status xml: " + e1);
        }
    }

    public void writeValidationErrors(HttpServletResponse response, ValidationException e) {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        if (e.hasErrors()) {
            for (ValidationError validationError : e.getGeneralErrors()) {
                sb.append(this.messageHelper.message(validationError.getKey(), validationError.getArguments())).append('\n');
            }
            for (Map.Entry entry : e.getErrorsByProperty().entrySet()) {
                String property = (String)entry.getKey();
                String key = e.getPropertyKey(property);
                String displayName = e.getPropertyDisplayName(property);
                String propertyMessage = property;
                if (key != null) {
                    propertyMessage = this.messageHelper.message(key, new Object[0]);
                } else if (displayName != null) {
                    propertyMessage = displayName;
                }
                for (ValidationError error : (Collection)entry.getValue()) {
                    ArrayList<Object> args = new ArrayList<Object>();
                    args.add(propertyMessage);
                    if (error.getArguments() != null) {
                        args.addAll(error.getArguments());
                    }
                    sb.append(this.messageHelper.message(error.getKey(), args.toArray())).append('\n');
                }
            }
        } else {
            sb.append(this.messageHelper.message("error.validation", new Object[0]));
        }
        fields.put("message", sb.toString());
        fields.put("properties", StringUtils.join(e.getErrorsByProperty().keySet().iterator(), (char)','));
        this.writeStatus(response, (Object)Status.ERROR, fields);
    }

    public void writeValidationSuccess(HttpServletResponse response) {
        this.writeStatus(response, (Object)Status.SUCCESS, null);
    }

    public static enum Status {
        SUCCESS,
        ERROR;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

