/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.Closeable;
import java.util.Iterator;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;

public class ScrollableResultsIterator<T>
implements Iterator<T>,
Closeable {
    private ScrollableResults results;
    private T nextObject;
    private Transformer<Object[], T> transformer;
    private boolean array;

    public ScrollableResultsIterator(Query query, Transformer<Object[], T> transformer) {
        this.results = query.scroll(ScrollMode.FORWARD_ONLY);
        this.array = query instanceof SQLQuery ? true : query.getReturnTypes().length > 1 && !query.getQueryString().trim().toLowerCase().startsWith("select new");
        this.transformer = transformer;
        this.getNextObject();
        DataIteratorHelper.registerOpen(this, true);
    }

    @Override
    public void close() {
        this.results.close();
    }

    @Override
    public boolean hasNext() {
        return this.nextObject != null;
    }

    @Override
    public T next() {
        T currentObject = this.nextObject;
        this.getNextObject();
        return currentObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void getNextObject() {
        this.nextObject = this.results.next() ? (this.transformer != null ? this.transformer.transform(this.results.get()) : (this.array ? this.results.get() : this.results.get(0))) : null;
    }
}

