/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.LinkedHashMap;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.utils.EnumHelper;
import org.springframework.web.context.ServletContextAware;

public class ServletContextHelper
implements ServletContextAware {
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.storeEnumMap(Module.class, Module.class.getSimpleName());
        this.storeEnumMap(BasicPermission.class, BasicPermission.class.getSimpleName());
        this.storeEnumMap(AdminSystemPermission.class, AdminSystemPermission.class.getSimpleName());
        this.storeEnumMap(AdminAdminPermission.class, AdminAdminPermission.class.getSimpleName());
        this.storeEnumMap(AdminMemberPermission.class, AdminMemberPermission.class.getSimpleName());
        this.storeEnumMap(MemberPermission.class, MemberPermission.class.getSimpleName());
        this.storeEnumMap(BrokerPermission.class, BrokerPermission.class.getSimpleName());
        this.storeEnumMap(OperatorPermission.class, OperatorPermission.class.getSimpleName());
    }

    public <E extends Enum<E>> void storeEnumMap(Class<E> enumType, final String name) {
        Enum[] values = EnumHelper.values(enumType);
        LinkedHashMap map = new LinkedHashMap<String, E>(){
            static final long serialVersionUID = 1L;

            @Override
            public E get(Object key) {
                if (!this.containsKey(key)) {
                    throw new IllegalArgumentException("Key not found on map for name: '" + name + "' and key: '" + key + "'");
                }
                return (Enum)super.get(key);
            }
        };
        for (Enum e : values) {
            map.put(e.name(), e);
        }
        this.servletContext.setAttribute(name, (Object)map);
    }
}

