/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.AlertSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.LogSettings;
import nl.strohalm.cyclos.entities.settings.MailSettings;
import nl.strohalm.cyclos.entities.settings.MailTranslation;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.PropertyHelper;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.web.context.ServletContextAware;

public class SettingsHelper
implements ServletContextAware {
    public static final String ACCESS_KEY = "accessSettings";
    public static final String ALERT_KEY = "alertSettings";
    public static final String LOCAL_KEY = "localSettings";
    public static final String LOG_KEY = "logSettings";
    public static final String MAIL_KEY = "mailSettings";
    public static final String MAIL_TRANSLATION_KEY = "mailTranslation";
    public static final String MESSAGE_KEY = "messageSettings";
    private SettingsService settingsService;

    public void setServletContext(ServletContext servletContext) {
        SettingsProxyMap accessProxy = new SettingsProxyMap(){

            @Override
            protected Object getSetting() {
                return SettingsHelper.this.getAccessSettings();
            }
        };
        servletContext.setAttribute(ACCESS_KEY, (Object)accessProxy);
        SettingsProxyMap alertProxy = new SettingsProxyMap(){

            @Override
            protected Object getSetting() {
                return SettingsHelper.this.getAlertSettings();
            }
        };
        servletContext.setAttribute(ALERT_KEY, (Object)alertProxy);
        SettingsProxyMap localProxy = new SettingsProxyMap(){

            @Override
            protected Object getSetting() {
                return SettingsHelper.this.getLocalSettings();
            }
        };
        servletContext.setAttribute(LOCAL_KEY, (Object)localProxy);
        SettingsProxyMap logProxy = new SettingsProxyMap(){

            @Override
            protected Object getSetting() {
                return SettingsHelper.this.getLogSettings();
            }
        };
        servletContext.setAttribute(LOG_KEY, (Object)logProxy);
        SettingsProxyMap mailProxy = new SettingsProxyMap(){

            @Override
            protected Object getSetting() {
                return SettingsHelper.this.getMailSettings();
            }
        };
        servletContext.setAttribute(MAIL_KEY, (Object)mailProxy);
        SettingsProxyMap mailTranslationProxy = new SettingsProxyMap(){

            @Override
            protected Object getSetting() {
                return SettingsHelper.this.getMailTranslation();
            }
        };
        servletContext.setAttribute(MAIL_TRANSLATION_KEY, (Object)mailTranslationProxy);
        SettingsProxyMap messageProxy = new SettingsProxyMap(){

            @Override
            protected Object getSetting() {
                return SettingsHelper.this.getMessageSettings();
            }
        };
        servletContext.setAttribute(MESSAGE_KEY, (Object)messageProxy);
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    private AccessSettings getAccessSettings() {
        return this.settingsService.getAccessSettings();
    }

    private AlertSettings getAlertSettings() {
        return this.settingsService.getAlertSettings();
    }

    private LocalSettings getLocalSettings() {
        return this.settingsService.getLocalSettings();
    }

    private LogSettings getLogSettings() {
        return this.settingsService.getLogSettings();
    }

    private MailSettings getMailSettings() {
        return this.settingsService.getMailSettings();
    }

    private MailTranslation getMailTranslation() {
        return this.settingsService.getMailTranslation();
    }

    private MessageSettings getMessageSettings() {
        return this.settingsService.getMessageSettings();
    }

    private static abstract class SettingsProxyMap
    implements Map<String, Object> {
        private Set<String> properties = new HashSet<String>();

        private SettingsProxyMap() {
            PropertyDescriptor[] descriptors;
            Object setting = this.getSetting();
            for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors((Object)setting)) {
                if (descriptor.getReadMethod() == null) continue;
                this.properties.add(descriptor.getName());
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.properties.contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
            Object setting = this.getSetting();
            for (String property : this.properties) {
                entries.add(new SettingsProxyMapEntry(setting, property));
            }
            return entries;
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException("Property " + key + " is not available in " + this.getSetting().getClass());
            }
            return PropertyHelper.get(this.getSetting(), key.toString());
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Set<String> keySet() {
            return Collections.unmodifiableSet(this.properties);
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.properties.size();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        protected abstract Object getSetting();

        private class SettingsProxyMapEntry
        implements Map.Entry<String, Object> {
            private final Object setting;
            private final String property;

            public SettingsProxyMapEntry(Object setting, String property) {
                this.setting = setting;
                this.property = property;
            }

            @Override
            public String getKey() {
                return this.property;
            }

            @Override
            public Object getValue() {
                return PropertyHelper.get(this.setting, this.property);
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

