/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.services.Service;
import nl.strohalm.cyclos.services.ServiceSecurity;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.ConversionException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class SpringHelper {
    public static <T> T bean(BeanFactory beanFactory, Class<T> requiredType) {
        Object bean = Service.class.isAssignableFrom(requiredType) ? beanFactory.getBean(StringUtils.uncapitalize((String)requiredType.getSimpleName())) : beanFactory.getBean(requiredType);
        SpringHelper.ensureSecurityService(bean, null);
        return (T)bean;
    }

    public static <T> T bean(ServletContext context, Class<T> requiredType) {
        return SpringHelper.bean((BeanFactory)WebApplicationContextUtils.getWebApplicationContext((ServletContext)context), requiredType);
    }

    public static void injectBeans(BeanFactory beanFactory, Object target) {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)target)) {
            Inject inject;
            Method setter = descriptor.getWriteMethod();
            if (setter == null || (inject = setter.getAnnotation(Inject.class)) == null) continue;
            String beanName = inject.value();
            if (StringUtils.isEmpty((String)beanName)) {
                beanName = descriptor.getName();
            }
            Object bean = beanFactory.getBean(beanName);
            SpringHelper.ensureSecurityService(bean, target);
            try {
                bean = CoercionHelper.coerce(descriptor.getPropertyType(), bean);
            }
            catch (ConversionException e) {
                throw new IllegalStateException("Bean " + beanName + " is not of the expected type type: " + descriptor.getPropertyType().getName());
            }
            try {
                setter.invoke(target, bean);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error setting bean " + bean + " on action " + target + " by injecting property " + descriptor.getName() + ": " + e, e);
            }
        }
        if (target instanceof InitializingBean) {
            try {
                ((InitializingBean)target).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Error after properties set on %1$s: %2$s", target, e.getMessage()), e);
            }
        }
    }

    public static void injectBeans(ServletContext context, Object target) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        SpringHelper.injectBeans((BeanFactory)applicationContext, target);
    }

    private static <T> void ensureSecurityService(T bean, Object target) {
        if (bean instanceof Service && !(bean instanceof ServiceSecurity)) {
            String msg = target == null ? String.format("It's trying to retrieve a local service (%1$s) from the web layer. You must use the remote service.", bean.getClass().getName(), target.getClass().getName()) : String.format("It's trying to inject a local service (%1$s) into a web component (%2$s). You must use the remote service.", bean.getClass().getName(), target.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
    }
}

