/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class StringHelper {
    private static final String MASK_VARIABLES = "#09aAlLuUcC?_";
    private static final String DIGITS = "0123456789";
    private static final String LOWERCASE_LETTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPERCASE_LETTERS = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxyz" + UPERCASE_LETTERS;

    public static String applyMask(String mask, String value) {
        if (StringUtils.isEmpty((String)mask) || value == null) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        boolean nextIsLiteral = false;
        int pos = 0;
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            if (c == '\\') {
                nextIsLiteral = true;
                continue;
            }
            if (!nextIsLiteral && MASK_VARIABLES.indexOf(c) >= 0) {
                try {
                    sb.append(value.charAt(pos++));
                }
                catch (StringIndexOutOfBoundsException e) {}
                continue;
            }
            nextIsLiteral = false;
            sb.append(c);
            if (!Character.isLetterOrDigit(c)) continue;
            ++pos;
        }
        return sb.toString();
    }

    public static String decodeUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static String encodeUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static boolean hasDigits(String string) {
        return StringUtils.containsAny((String)string, (String)DIGITS);
    }

    public static boolean hasLetters(String string) {
        return StringUtils.containsAny((String)string, (String)LETTERS);
    }

    public static boolean hasSpecial(String string) {
        int length;
        int n = length = string == null ? 0 : string.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (LETTERS.indexOf(c) >= 0 || DIGITS.indexOf(c) >= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidJavaIdentifier(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String onlyNumbers(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder numbers = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) continue;
            numbers.append(c);
        }
        return numbers.toString();
    }

    public static String removeCarriageReturnCharater(String text) {
        return StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
    }

    public static String removeMarkupTags(String string) {
        return StringHelper.removeMarkupTagsAndUnescapeEntities(string, false);
    }

    public static String removeMarkupTagsAndUnescapeEntities(String string) {
        return StringHelper.removeMarkupTagsAndUnescapeEntities(string, true);
    }

    public static String removeMask(String mask, String value) {
        return StringHelper.removeMask(mask, value, true);
    }

    public static String removeMask(String mask, String value, boolean trimToMask) {
        if (StringUtils.isEmpty((String)mask) || value == null) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        boolean nextIsLiteral = false;
        int pos = 0;
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            if (c == '\\') {
                nextIsLiteral = true;
                continue;
            }
            if (!nextIsLiteral && MASK_VARIABLES.indexOf(c) >= 0) {
                try {
                    while (!Character.isLetterOrDigit(value.charAt(pos))) {
                        ++pos;
                    }
                    sb.append(value.charAt(pos++));
                    continue;
                }
                catch (StringIndexOutOfBoundsException e) {
                    break;
                }
            }
            if (!nextIsLiteral) continue;
            nextIsLiteral = false;
            sb.append(c);
            ++pos;
        }
        if (!trimToMask) {
            sb.append(value.substring(pos));
        }
        return sb.toString();
    }

    public static String removeQueryStringVariable(String queryString, String var) {
        int pos = queryString.indexOf(var + "=");
        if (pos >= 0) {
            int end = queryString.indexOf(38, pos);
            if (end < 0) {
                end = queryString.length();
            }
            queryString = queryString.substring(0, pos) + queryString.substring(end);
        }
        return queryString;
    }

    public static String replaceSupplementaryCharacters(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        boolean isSupplementary = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int cp = Character.codePointAt(text, i);
            isSupplementary = Character.isSupplementaryCodePoint(cp);
            if (isSupplementary) {
                result.append("?");
                ++i;
                continue;
            }
            result.append(text.charAt(i));
        }
        return result.toString();
    }

    public static String upcase(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(c);
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    private static String removeMarkupTagsAndUnescapeEntities(String string, boolean unescapeEntities) {
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int length = string.length();
        boolean inTag = false;
        boolean inComments = false;
        boolean hasText = false;
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c == '<' && i < length - 1 && (Character.isLetterOrDigit(string.charAt(i + 1)) || string.charAt(i + 1) == '/')) {
                inTag = true;
                continue;
            }
            if (i < length - 4 && "<!--".equals(string.substring(i, i + 4))) {
                inComments = true;
                i += 3;
                continue;
            }
            if (inComments && i < length - 3 && "-->".equals(string.substring(i, i + 3))) {
                inComments = false;
                hasText = false;
                i += 2;
                continue;
            }
            if (c == '>') {
                inTag = false;
                hasText = false;
                continue;
            }
            if (inTag || inComments) continue;
            if (!hasText) {
                hasText = true;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
            }
            sb.append(c);
        }
        string = sb.toString();
        if (unescapeEntities) {
            string = StringEscapeUtils.unescapeHtml((String)string);
        }
        return string;
    }
}

