/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.Serializable;
import java.util.Calendar;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.IntValuedEnum;
import nl.strohalm.cyclos.utils.Period;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.DateUtils;

public class TimePeriod
implements Serializable,
Cloneable {
    public static final TimePeriod ONE_MONTH = new TimePeriod(1, Field.MONTHS);
    public static final TimePeriod ONE_DAY = new TimePeriod(1, Field.DAYS);
    private static final long serialVersionUID = 859616150477032565L;
    private int number;
    private Field field;

    public TimePeriod() {
    }

    public TimePeriod(int number, Field field) {
        this.number = number;
        this.field = field == null ? Field.DAYS : field;
    }

    public Calendar add(Calendar date) {
        if (date == null) {
            return null;
        }
        if (!this.isValid()) {
            return date;
        }
        Calendar ret = (Calendar)date.clone();
        ret.add(this.field.getCalendarValue(), this.number);
        return ret;
    }

    public TimePeriod clone() {
        try {
            return (TimePeriod)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Period currentPeriod(Calendar date) {
        Calendar start = this.previousPeriod(date).getEnd();
        start.add(13, 1);
        return this.periodStartingAt(start);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimePeriod)) {
            return false;
        }
        TimePeriod tp = (TimePeriod)obj;
        return new EqualsBuilder().append(this.number, tp.number).append((Object)this.field, (Object)tp.field).isEquals();
    }

    public Field getField() {
        return this.field;
    }

    public int getNumber() {
        return this.number;
    }

    public float getValueIn(Field field) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        Calendar cal2 = this.add(cal);
        float millisDiff = cal2.getTimeInMillis() - cal.getTimeInMillis();
        switch (field) {
            case MILLIS: {
                return millisDiff;
            }
            case SECONDS: {
                return millisDiff / 1000.0f;
            }
            case MINUTES: {
                return millisDiff / 60000.0f;
            }
            case HOURS: {
                return millisDiff / 3600000.0f;
            }
            case DAYS: {
                return millisDiff / 8.64E7f;
            }
            case WEEKS: {
                return millisDiff / 6.048E8f;
            }
            case MONTHS: {
                return millisDiff / 2.592E9f;
            }
            case YEARS: {
                return millisDiff / 3.1536E10f;
            }
        }
        return 0.0f;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.number).append((Object)this.field).toHashCode();
    }

    public boolean isValid() {
        return this.number > 0 && this.field != null;
    }

    public Period periodEndingAt(Calendar endDate) {
        endDate = (Calendar)endDate.clone();
        Calendar beginDate = this.remove(endDate);
        endDate.add(13, -1);
        return Period.between(beginDate, endDate);
    }

    public Period periodStartingAt(Calendar beginDate) {
        Calendar endDate = this.add(beginDate);
        endDate.add(13, -1);
        return Period.between(beginDate, endDate);
    }

    public Period previousPeriod(Calendar date) {
        Calendar end;
        if (this.field == Field.WEEKS) {
            end = DateHelper.truncate(date);
            while (end.get(7) != 2) {
                end.add(5, -1);
            }
        } else {
            end = DateUtils.truncate((Calendar)date, (int)this.field.getCalendarValue());
        }
        return this.periodEndingAt(end);
    }

    public Calendar remove(Calendar date) {
        if (date == null) {
            return null;
        }
        if (!this.isValid()) {
            return date;
        }
        Calendar ret = (Calendar)date.clone();
        ret.add(this.field.getCalendarValue(), -this.number);
        return ret;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String toString() {
        return this.number + " " + this.field;
    }

    public static enum Field implements IntValuedEnum
    {
        MILLIS(14),
        SECONDS(13),
        MINUTES(12),
        HOURS(11, 10),
        DAYS(5),
        WEEKS(3),
        MONTHS(2),
        YEARS(1);

        private int[] calendarValues;

        public static Field findByCalendarField(int value) {
            for (Field field : Field.values()) {
                if (!ArrayUtils.contains((int[])field.calendarValues, (int)value)) continue;
                return field;
            }
            return null;
        }

        private Field(int calendarValue) {
            this.calendarValues = new int[]{calendarValue};
        }

        private Field(int ... calendarValues) {
            this.calendarValues = calendarValues;
        }

        public int getCalendarValue() {
            return this.calendarValues[0];
        }

        @Override
        public int getValue() {
            return this.getCalendarValue();
        }
    }
}

