/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import nl.strohalm.cyclos.entities.accounts.LockedAccountsOnPayments;
import nl.strohalm.cyclos.entities.exceptions.LockingException;
import nl.strohalm.cyclos.exceptions.ApplicationException;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.utils.ExceptionHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.Transactional;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionHelperImpl
implements TransactionHelper {
    private static Log LOG = LogFactory.getLog((String)TransactionHelper.class.getName());
    private TransactionTemplate transactionTemplate;
    private ApplicationServiceLocal applicationService;
    private SessionFactory sessionFactory;
    private ThreadPoolTaskExecutor taskExecutor;

    @Override
    public boolean hasActiveTransaction() {
        return TransactionSynchronizationManager.hasResource((Object)this.sessionFactory);
    }

    @Override
    public <T> T maybeRunInNewTransaction(TransactionCallback<T> callback) {
        return this.maybeRunInNewTransaction(callback, true, LockedAccountsOnPayments.ORIGIN);
    }

    @Override
    public <T> T maybeRunInNewTransaction(TransactionCallback<T> callback, boolean newTransaction) {
        return this.maybeRunInNewTransaction(callback, newTransaction, LockedAccountsOnPayments.ORIGIN);
    }

    @Override
    public <T> T maybeRunInNewTransaction(TransactionCallback<T> callback, boolean newTransaction, LockedAccountsOnPayments minForNewTx) {
        if (newTransaction && this.applicationService.getLockedAccountsOnPayments().compareTo(minForNewTx) >= 0) {
            return this.runInNewTransaction(callback);
        }
        return (T)callback.doInTransaction(null);
    }

    @Override
    public <T> Future<T> runAsync(TransactionCallback<T> callback) {
        if (callback instanceof Transactional) {
            throw new IllegalArgumentException("runAsync doesn't support a Transactional, only plain TransactionCallbacks");
        }
        return new FutureAdapter<T>(this.submit(callback, true));
    }

    @Override
    public <T> T runInCurrentThread(TransactionCallback<T> callback) {
        return (T)((RunResult)this.runInCurrentThreadWithResult(callback, true)).getResultOrThrowError();
    }

    @Override
    public <T> T runInNewTransaction(TransactionCallback<T> callback) {
        Future<RunResult<T>> future = this.submit(callback, false);
        try {
            RunResult<T> runResult = future.get();
            ((RunResult)runResult).getResultOrThrowError();
            ((RunResult)runResult).maybeRunAfterCommit(callback);
            return (T)((RunResult)runResult).result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setTaskExecutor(ThreadPoolTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    private <T> RunResult<T> runInCurrentThreadWithResult(final TransactionCallback<T> callback, boolean runTransactional) {
        RunResult result;
        do {
            try {
                result = (RunResult)this.transactionTemplate.execute(new TransactionCallback<RunResult<T>>(){

                    public RunResult<T> doInTransaction(TransactionStatus status) {
                        RunResult result = new RunResult();
                        try {
                            result.result = callback.doInTransaction(status);
                            result.commit = !status.isRollbackOnly();
                        }
                        catch (LockingException e) {
                            status.setRollbackOnly();
                            result.retry = true;
                        }
                        catch (ApplicationException e) {
                            if (e.isShouldRollback()) {
                                status.setRollbackOnly();
                            } else {
                                result.commit = true;
                            }
                            result.error = e;
                        }
                        catch (Throwable e) {
                            status.setRollbackOnly();
                            result.error = e;
                        }
                        return result;
                    }
                });
            }
            catch (Throwable t) {
                result = new RunResult();
                if (ExceptionHelper.isLockingException(t)) {
                    result.retry = true;
                }
                result.error = t;
            }
            CurrentTransactionData.detachListeners().runListeners(result.commit);
            CurrentTransactionData.cleanup();
        } while (result.retry);
        if (runTransactional) {
            result.maybeRunAfterCommit(callback);
        }
        return result;
    }

    private <T> Future<RunResult<T>> submit(TransactionCallback<T> callback, boolean logExceptions) {
        TransactionCallable callable = new TransactionCallable(LoggedUser.getAttributes(), callback, logExceptions);
        return this.taskExecutor.submit(callable);
    }

    private class TransactionCallable<T>
    implements Callable<RunResult<T>> {
        private final Map<String, Object> loggedUserAttributes;
        private final TransactionCallback<T> callback;
        private final boolean logExceptions;
        private RunResult<T> runResult;

        private TransactionCallable(Map<String, Object> loggedUserAttributes, TransactionCallback<T> callback, boolean logExceptions) {
            this.loggedUserAttributes = loggedUserAttributes;
            this.callback = callback;
            this.logExceptions = logExceptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunResult<T> call() throws Exception {
            try {
                LoggedUser.init(this.loggedUserAttributes);
                this.runResult = TransactionHelperImpl.this.runInCurrentThreadWithResult(this.callback, false);
                if (this.logExceptions && ((RunResult)this.runResult).error != null && !(((RunResult)this.runResult).error instanceof LockingException)) {
                    LOG.error((Object)"Error while executing task by TransactionHelper", ((RunResult)this.runResult).error);
                }
                RunResult<T> runResult = this.runResult;
                return runResult;
            }
            finally {
                LoggedUser.cleanup();
            }
        }
    }

    private static class RunResult<T> {
        private T result;
        private Throwable error;
        private boolean commit;
        private boolean retry;

        private RunResult() {
        }

        private T getResultOrThrowError() {
            if (this.error != null) {
                throw this.error instanceof RuntimeException ? (RuntimeException)this.error : new RuntimeException(this.error);
            }
            return this.result;
        }

        private void maybeRunAfterCommit(TransactionCallback<T> callback) {
            if (this.commit && callback instanceof Transactional) {
                Transactional transactional = (Transactional)callback;
                transactional.afterCommit(this.result);
            }
        }
    }

    private static class FutureAdapter<T>
    implements Future<T> {
        private final Future<RunResult<T>> future;

        public FutureAdapter(Future<RunResult<T>> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            RunResult<T> runResult = this.future.get();
            if (((RunResult)runResult).error != null) {
                throw new ExecutionException(((RunResult)runResult).error);
            }
            return (T)((RunResult)runResult).result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            RunResult<T> runResult = this.future.get(timeout, unit);
            if (((RunResult)runResult).error != null) {
                throw new ExecutionException(((RunResult)runResult).error);
            }
            return (T)((RunResult)runResult).result;
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }
    }
}

