/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.File;
import java.sql.Blob;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.customizedfile.CustomizedFileHandler;
import org.springframework.web.context.ServletContextAware;

public final class WebImageHelper
implements ServletContextAware {
    public static final String SYSTEM_IMAGES_PATH = "/pages/images";
    public static final String SYSTEM_THUMBNAILS_PATH = "/pages/images/thumbnails";
    public static final String SYSTEM_IMAGES_MAP_KEY = "systemImages";
    public static final String CUSTOM_IMAGES_PATH = "/pages/images/custom";
    public static final String CUSTOM_THUMBNAILS_PATH = "/pages/images/custom/thumbnails";
    public static final String STYLE_IMAGES_PATH = "/pages/styles";
    public static final String STYLE_THUMBNAILS_PATH = "/pages/styles/thumbnails";
    private ServletContext servletContext;
    private CustomizedFileHandler customizedFileHandler;
    private CustomizationHelper customizationHelper;

    public File imagePath(Image.Nature nature) {
        String path = null;
        switch (nature) {
            case SYSTEM: {
                path = SYSTEM_IMAGES_PATH;
                break;
            }
            case CUSTOM: {
                path = CUSTOM_IMAGES_PATH;
                break;
            }
            case STYLE: {
                path = STYLE_IMAGES_PATH;
                break;
            }
            default: {
                return null;
            }
        }
        return new File(this.servletContext.getRealPath(path));
    }

    public void remove(Image image) {
        Image.Nature nature = image.getNature();
        if (nature != Image.Nature.CUSTOM && nature != Image.Nature.STYLE) {
            return;
        }
        File imageFile = new File(this.imagePath(nature), image.getName());
        this.customizationHelper.deleteFile(imageFile);
        File thumbnailFile = new File(this.thumbnailPath(nature), image.getName());
        this.customizationHelper.deleteFile(thumbnailFile);
        Long id = image.getId();
        this.customizedFileHandler.delete("/pages/images/cache/images/" + id);
        this.customizedFileHandler.delete("/pages/images/cache/thumbnails/" + id);
    }

    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    public void setCustomizedFileHandler(CustomizedFileHandler customizedFileHandler) {
        this.customizedFileHandler = customizedFileHandler;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public File thumbnailPath(Image.Nature nature) {
        String path = null;
        switch (nature) {
            case SYSTEM: {
                path = SYSTEM_THUMBNAILS_PATH;
                break;
            }
            case CUSTOM: {
                path = CUSTOM_THUMBNAILS_PATH;
                break;
            }
            case STYLE: {
                path = STYLE_THUMBNAILS_PATH;
                break;
            }
            default: {
                return null;
            }
        }
        return new File(this.servletContext.getRealPath(path));
    }

    public void update(Image image) {
        Image.Nature nature = image.getNature();
        if (!this.updateNature(nature)) {
            return;
        }
        this.updateImage(false, image, this.imagePath(nature));
        this.updateImage(true, image, this.thumbnailPath(nature));
        this.customizedFileHandler.notifyImageChangeListeners(image);
    }

    public boolean updateNature(Image.Nature nature) {
        return nature != null && nature.getOwnerType() == null;
    }

    private void updateImage(boolean isThumbnail, Image image, File dir) {
        byte[] contents;
        if (dir == null) {
            return;
        }
        Blob blob = isThumbnail ? image.getThumbnail() : image.getImage();
        try {
            contents = blob.getBytes(1L, (int)blob.length());
        }
        catch (Exception e) {
            throw new IllegalStateException("Error reading the image contents", e);
        }
        File file = new File(dir, image.getName());
        long lastModified = image.getLastModified().getTimeInMillis();
        this.customizationHelper.updateFile(file, lastModified, contents);
    }
}

