/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class WhitelistValidator {
    private final List<String> allowed = new ArrayList<String>();

    private static boolean isHost(String string) {
        try {
            return !Character.isDigit(string.charAt(0));
        }
        catch (Exception e) {
            return false;
        }
    }

    public WhitelistValidator(String data) {
        this.parse(data);
    }

    public List<String> getAllowedAddrs() {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this.allowed) {
            if (WhitelistValidator.isHost(string)) continue;
            list.add(string);
        }
        return list;
    }

    public List<String> getAllowedHosts() {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this.allowed) {
            if (!WhitelistValidator.isHost(string)) continue;
            list.add(string);
        }
        return list;
    }

    public boolean isAllowed(String address) {
        if (this.allowed.isEmpty()) {
            return true;
        }
        if ((address = StringUtils.trimToNull((String)address)) == null) {
            return false;
        }
        for (String test : this.allowed) {
            String regExp = StringUtils.replace((String)StringUtils.replace((String)StringUtils.replace((String)test, (String)".", (String)"\\."), (String)"*", (String)".*"), (String)"?", (String)".");
            if (!address.matches(regExp)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowed(String host, String addr) {
        boolean allowed = this.isAllowed(addr);
        if (allowed) {
            return true;
        }
        if (ObjectUtils.equals((Object)host, (Object)addr)) {
            for (String current : this.getAllowedHosts()) {
                try {
                    InetAddress[] addresses;
                    for (InetAddress address : addresses = InetAddress.getAllByName(current)) {
                        if (!address.getHostAddress().equals(addr)) continue;
                        return true;
                    }
                }
                catch (UnknownHostException e) {
                }
            }
            return false;
        }
        return this.isAllowed(host);
    }

    private void parse(String data) {
        String[] lines;
        for (String line : lines = StringUtils.split((String)StringUtils.trimToEmpty((String)data), (String)"\n")) {
            if ((line = StringUtils.trimToEmpty((String)line)).length() == 0 || line.charAt(0) == '#') continue;
            this.allowed.add(line);
        }
    }
}

