/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WorkerThreads<T> {
    private static final long CHECK_INTERVAL = 60000L;
    private static final Log LOG = LogFactory.getLog(WorkerThreads.class);
    private String name;
    private List<WorkerThread> threads;
    private int maxThreads;
    private BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private long threadIndex;
    private Timer cleanUpTimer;

    protected WorkerThreads(String name, int maxThreads) {
        this(name, maxThreads, true);
    }

    protected WorkerThreads(String name, int maxThreads, boolean purgeOld) {
        this.name = name;
        this.maxThreads = maxThreads;
        this.threads = Collections.synchronizedList(new LinkedList());
        if (purgeOld) {
            this.cleanUpTimer = new Timer("Clean up timer for " + name);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    WorkerThreads.this.interruptOldThreads();
                }
            };
            this.cleanUpTimer.scheduleAtFixedRate(task, 60000L, 60000L);
        }
    }

    public synchronized void enqueue(T object) {
        if (this.maxThreads <= 0) {
            return;
        }
        this.queue.offer(object);
        int queueSize = this.queue.size();
        int threadsSize = this.threads.size();
        if (threadsSize < this.maxThreads && threadsSize < queueSize) {
            WorkerThread thread = new WorkerThread();
            thread.setName("#" + this.threadIndex++ + " " + this.name);
            this.threads.add(thread);
            thread.start();
        }
    }

    public void enqueueAll(Collection<T> objects) {
        for (T object : objects) {
            this.enqueue(object);
        }
    }

    public synchronized void interrupt() {
        if (this.cleanUpTimer != null) {
            this.cleanUpTimer.cancel();
        }
        for (WorkerThread thread : this.threads) {
            thread.interrupt();
        }
        this.threads.clear();
    }

    protected abstract void process(T var1);

    private synchronized void interruptOldThreads() {
        long tolerance = System.currentTimeMillis() - 60000L;
        Iterator<WorkerThread> iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            WorkerThread thread = iterator.next();
            if (thread.lastUsedAt >= tolerance || thread.inProcess) continue;
            thread.interrupt();
            iterator.remove();
        }
    }

    private final class WorkerThread
    extends Thread {
        private long lastUsedAt;
        private boolean inProcess;

        private WorkerThread() {
        }

        @Override
        public void run() {
            while (true) {
                Object object;
                try {
                    object = WorkerThreads.this.queue.take();
                }
                catch (InterruptedException e) {
                    break;
                }
                this.inProcess = true;
                this.lastUsedAt = System.currentTimeMillis();
                LoggedUser.runAsSystem(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            WorkerThreads.this.process(object);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error processing work by " + WorkerThreads.this.name), (Throwable)e);
                        }
                        return null;
                    }
                });
                this.inProcess = false;
            }
        }
    }
}

