/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlHelper {
    public static void clear(Element element) {
        Node node;
        if (element == null) {
            return;
        }
        while ((node = element.getFirstChild()) != null) {
            element.removeChild(node);
        }
    }

    public static List<Element> getChilden(Element element, String tagName) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem;
            Node item = nodes.item(i);
            if (!(item instanceof Element) || !tagName.equals((elem = (Element)item).getTagName())) continue;
            children.add(elem);
        }
        return children;
    }

    public static Document readDocument(InputStream in) {
        return XmlHelper.readDocument(new InputSource(in));
    }

    public static Document readDocument(String xml) {
        return XmlHelper.readDocument(new InputSource(new StringReader(xml)));
    }

    public static String toString(Node node) {
        StringWriter out = new StringWriter();
        XmlHelper.write(node, new StreamResult(out));
        return out.toString();
    }

    public static void writeNode(Node node, OutputStream out) {
        XmlHelper.write(node, new StreamResult(out));
    }

    private static Document readDocument(InputSource inputSource) {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error creating the document builder", e);
        }
        try {
            return documentBuilder.parse(inputSource);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing xml file", e);
        }
    }

    private static void write(Node node, Result result) {
        try {
            DOMSource source = new DOMSource(node);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }
}

