/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.access;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import org.apache.commons.collections.MapUtils;

public class LoggedUser {
    private static final String ACCESS_TYPE_KEY = "cyclos.loggedUser.accessType";
    private static final String ELEMENT_KEY = "cyclos.loggedUser.element";
    private static final String GROUP_KEY = "cyclos.loggedUser.group";
    private static final String USER_KEY = "cyclos.loggedUser.user";
    private static final String REMOTE_ADDRESS_KEY = "cyclos.loggedUser.remoteAddress";
    private static final String SERVICE_CLIENT_KEY = "cyclos.loggedUser.serviceClient";
    private static final String POS_KEY = "cyclos.loggedUser.pos";
    private static final ThreadLocal<Map<String, Object>> ATTRIBUTES = new ThreadLocal();

    public static AccountOwner accountOwner() {
        Object loggedElement = LoggedUser.element();
        return ((Element)loggedElement).getAccountOwner();
    }

    public static void cleanup() {
        Map<String, Object> map = ATTRIBUTES.get();
        if (map != null) {
            map.clear();
        }
        ATTRIBUTES.remove();
    }

    public static <E extends Element> E element() {
        Element element = (Element)LoggedUser.getAttribute(ELEMENT_KEY);
        if (element == null) {
            throw new NotConnectedException();
        }
        return (E)element;
    }

    public static AccessType getAccessType() {
        return (AccessType)((Object)LoggedUser.getAttribute(ACCESS_TYPE_KEY));
    }

    public static <T> T getAttribute(String key) {
        Map<String, Object> map = ATTRIBUTES.get();
        if (map != null) {
            return (T)map.get(key);
        }
        return null;
    }

    public static Map<String, Object> getAttributes() {
        Map<String, Object> attributes = ATTRIBUTES.get();
        if (attributes == null) {
            return null;
        }
        return new HashMap<String, Object>(attributes);
    }

    public static <G extends Group> G group() {
        Group group = (Group)LoggedUser.getAttribute(GROUP_KEY);
        if (group == null) {
            throw new NotConnectedException();
        }
        return (G)group;
    }

    public static boolean hasUser() {
        return LoggedUser.getAttribute(ELEMENT_KEY) != null;
    }

    public static void init(Map<String, Object> attributes) {
        if (MapUtils.isNotEmpty(attributes)) {
            ATTRIBUTES.set(attributes);
        }
    }

    public static void init(Pos pos, String remoteAddress, Map<String, Object> attributes) {
        Member member = pos.getMemberPos().getMember();
        Map<String, Object> map = LoggedUser.initMap(AccessType.WEB_SERVICE, member, remoteAddress, attributes);
        map.put(POS_KEY, pos);
    }

    public static void init(ServiceClient serviceClient, String remoteAddress, Map<String, Object> attributes) {
        Member member = serviceClient.getMember();
        Map<String, Object> map = LoggedUser.initMap(AccessType.WEB_SERVICE, member, remoteAddress, attributes);
        map.put(SERVICE_CLIENT_KEY, serviceClient);
    }

    public static void init(User user) {
        LoggedUser.init(user, null, null);
    }

    public static void init(User user, String remoteAddress) {
        LoggedUser.init(user, remoteAddress, null);
    }

    public static void init(User user, String remoteAddress, Map<String, Object> attributes) {
        LoggedUser.initMap(AccessType.USER, user.getElement(), remoteAddress, attributes);
    }

    public static boolean isAdministrator() {
        return LoggedUser.getAttribute(GROUP_KEY) instanceof AdminGroup;
    }

    public static boolean isBroker() {
        return LoggedUser.getAttribute(GROUP_KEY) instanceof BrokerGroup;
    }

    public static boolean isMember() {
        return LoggedUser.getAttribute(GROUP_KEY) instanceof MemberGroup;
    }

    public static boolean isOperator() {
        return LoggedUser.getAttribute(GROUP_KEY) instanceof OperatorGroup;
    }

    public static boolean isSystem() {
        return LoggedUser.getAccessType() == AccessType.SYSTEM;
    }

    public static boolean isSystemOrUnrestrictedClient() {
        return LoggedUser.isSystem() || LoggedUser.isUnrestrictedClient();
    }

    public static boolean isUnrestrictedClient() {
        return LoggedUser.isWebService() && ATTRIBUTES.get().get(SERVICE_CLIENT_KEY) != null && !LoggedUser.hasUser();
    }

    public static boolean isWebService() {
        return LoggedUser.getAccessType() == AccessType.WEB_SERVICE;
    }

    public static Member member() {
        Object element = LoggedUser.getAttribute(ELEMENT_KEY);
        if (element instanceof Member) {
            return (Member)element;
        }
        if (element instanceof Operator) {
            return ((Operator)element).getMember();
        }
        return null;
    }

    public static Pos pos() {
        return (Pos)LoggedUser.getAttribute(POS_KEY);
    }

    public static String remoteAddress() {
        return (String)LoggedUser.getAttribute(REMOTE_ADDRESS_KEY);
    }

    public static <T> T runAs(User user, Callable<T> callable) {
        return LoggedUser.runAs(user, null, callable);
    }

    public static <T> T runAs(User user, String remoteAddress, Callable<T> callable) {
        Map<String, Object> previousAttributes = ATTRIBUTES.get();
        try {
            LoggedUser.init(user, remoteAddress);
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ATTRIBUTES.set(previousAttributes);
        }
    }

    public static <T> T runAsSystem(Callable<T> callable) {
        Map<String, Object> previousAttributes = null;
        boolean alreadyRunninAsSystem = LoggedUser.isSystem();
        if (!alreadyRunninAsSystem) {
            previousAttributes = ATTRIBUTES.get();
        }
        try {
            if (!alreadyRunninAsSystem) {
                LoggedUser.initAsSystem();
            }
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!alreadyRunninAsSystem) {
                ATTRIBUTES.set(previousAttributes);
            }
        }
    }

    public static ServiceClient serviceClient() {
        return (ServiceClient)LoggedUser.getAttribute(SERVICE_CLIENT_KEY);
    }

    public static void setAttribute(String key, Object value) {
        Map<String, Object> map = ATTRIBUTES.get();
        if (map != null) {
            map.put(key, value);
        }
    }

    public static <U extends User> U user() {
        User user = (User)LoggedUser.getAttribute(USER_KEY);
        if (user == null) {
            throw new NotConnectedException();
        }
        return (U)user;
    }

    private static void initAsSystem() {
        LoggedUser.initMap(AccessType.SYSTEM, null, null, null);
    }

    private static Map<String, Object> initMap(AccessType accessType, Element element, String remoteAddress, Map<String, Object> attributes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACCESS_TYPE_KEY, (Object)accessType);
        if (element != null) {
            map.put(ELEMENT_KEY, element);
            map.put(USER_KEY, element.getUser());
            map.put(GROUP_KEY, element.getGroup());
        }
        map.put(REMOTE_ADDRESS_KEY, remoteAddress);
        if (attributes != null) {
            map.putAll(attributes);
        }
        ATTRIBUTES.set(map);
        return map;
    }

    public static enum AccessType {
        SYSTEM,
        USER,
        WEB_SERVICE;

    }
}

