/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.ModuleType;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class PermissionHelper {
    private static final char[] NAME_DELIMITERS = new char[]{'_'};
    private static Map<String, Class<?>> permissionsBySimpleName = new HashMap();

    public static <T> void checkContains(Collection<? super T> allowed, T element) {
        if (allowed == null || !allowed.contains(element)) {
            throw new PermissionDeniedException();
        }
    }

    public static void checkEquals(Object expected, Object actual) {
        if (!ObjectUtils.equals((Object)expected, (Object)actual)) {
            throw new PermissionDeniedException();
        }
    }

    public static <T> Collection<T> checkSelection(Collection<T> allowed, Collection<T> selection) {
        return PermissionHelper.checkSelection(allowed, selection, false);
    }

    public static <T> Collection<T> checkSelection(Collection<T> allowed, Collection<T> selection, boolean isEmptyAllowedSupported) {
        if (CollectionUtils.isEmpty(allowed)) {
            if (!isEmptyAllowedSupported || CollectionUtils.isNotEmpty(selection)) {
                throw new PermissionDeniedException();
            }
            return null;
        }
        if (CollectionUtils.isEmpty(selection)) {
            return allowed;
        }
        if (!allowed.containsAll(selection)) {
            throw new PermissionDeniedException();
        }
        return selection;
    }

    public static <T extends Enum<T>> Permission find(Permission perm, Class<T> enumType) {
        try {
            T enumItem = Enum.valueOf(enumType, perm.name());
            return (Permission)enumItem;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Collection<? extends Entity> getAllowedValues(Group group, Permission permission) {
        Collection<? extends Entity> current;
        Class<?> clazz = permission.getClass();
        if (clazz == BrokerPermission.class) {
            current = PermissionHelper.getCurrentValues((BrokerGroup)group, (BrokerPermission)permission);
        } else if (clazz == MemberPermission.class) {
            current = PermissionHelper.getCurrentValues((MemberGroup)group, (MemberPermission)permission);
        } else if (clazz == OperatorPermission.class) {
            current = PermissionHelper.getCurrentValues((OperatorGroup)group, (OperatorPermission)permission);
        } else if (clazz == AdminAdminPermission.class) {
            current = PermissionHelper.getCurrentValues((AdminGroup)group, (AdminAdminPermission)permission);
        } else if (clazz == AdminMemberPermission.class) {
            current = PermissionHelper.getCurrentValues((AdminGroup)group, (AdminMemberPermission)permission);
        } else if (clazz == AdminSystemPermission.class) {
            current = PermissionHelper.getCurrentValues((AdminGroup)group, (AdminSystemPermission)permission);
        } else {
            throw new IllegalArgumentException("Unsupported permission class: " + clazz);
        }
        return current;
    }

    public static Collection<Permission> getMultivaluedPermissions(Group.Nature groupNature) {
        ArrayList<Permission> list = new ArrayList<Permission>();
        for (ModuleType moduleType : ModuleType.getModuleTypes(groupNature)) {
            for (Module module : moduleType.getModules()) {
                for (Permission permission : module.getPermissions()) {
                    PermissionHelper.addListPermission(list, permission);
                }
            }
        }
        return Collections.unmodifiableCollection(list);
    }

    public static Permission getPermission(String qualifiedPermissionName) {
        String[] valueParts = StringUtils.split((String)qualifiedPermissionName, (String)".");
        Class<?> permissionClass = permissionsBySimpleName.get(valueParts[0]);
        if (permissionClass == null) {
            throw new IllegalArgumentException("Invalid permission class simple name: " + valueParts[0]);
        }
        return (Permission)Enum.valueOf(permissionClass, valueParts[1]);
    }

    public static String getQualifiedPermissionName(Permission permission) {
        return permission.getClass().getSimpleName() + "." + permission.name();
    }

    public static String getValue(Module module) {
        return PermissionHelper.process(PermissionHelper.getValue(module.name()));
    }

    public static String getValue(Permission permission) {
        String prefix = PermissionHelper.getValue(permission.getModule().name());
        String suffix = PermissionHelper.getValue(permission.name());
        String[] parts = suffix.split("\\_");
        for (int i = 0; i < parts.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                if (sb.length() > 0) {
                    sb.append('_');
                }
                sb.append(parts[j]);
            }
            if (!prefix.endsWith(sb.toString())) continue;
            if (!(suffix = suffix.substring(sb.length())).startsWith("_")) break;
            suffix = suffix.substring(1);
            break;
        }
        return PermissionHelper.process(prefix) + "." + PermissionHelper.process(suffix);
    }

    private static void addListPermission(Collection<Permission> list, Permission permission) {
        if (permission.relationship() != null) {
            list.add(permission);
        }
    }

    private static Collection<? extends Entity> getCurrentValues(AdminGroup adminGroup, AdminAdminPermission permission) {
        Collection<MemberRecordType> current;
        switch (permission) {
            case RECORDS_CREATE: {
                current = adminGroup.getCreateAdminRecordTypes();
                break;
            }
            case RECORDS_DELETE: {
                current = adminGroup.getDeleteAdminRecordTypes();
                break;
            }
            case RECORDS_MODIFY: {
                current = adminGroup.getModifyAdminRecordTypes();
                break;
            }
            case RECORDS_VIEW: {
                current = adminGroup.getViewAdminRecordTypes();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
            }
        }
        return current;
    }

    private static Collection<? extends Entity> getCurrentValues(AdminGroup adminGroup, AdminMemberPermission permission) {
        Collection<Entity> current;
        switch (permission) {
            case MEMBERS_VIEW: {
                current = adminGroup.getManagesGroups();
                break;
            }
            case DOCUMENTS_DETAILS: {
                current = adminGroup.getDocuments();
                break;
            }
            case GUARANTEES_REGISTER_GUARANTEES: {
                current = adminGroup.getGuaranteeTypes();
                break;
            }
            case LOANS_GRANT: {
                current = adminGroup.getTransferTypes();
                break;
            }
            case MESSAGES_VIEW: {
                current = adminGroup.getMessageCategories();
                break;
            }
            case PAYMENTS_CHARGEBACK: {
                current = adminGroup.getChargebackTransferTypes();
                break;
            }
            case PAYMENTS_PAYMENT: {
                current = adminGroup.getTransferTypes();
                break;
            }
            case PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER: {
                current = adminGroup.getTransferTypesAsMember();
                break;
            }
            case PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF: {
                current = adminGroup.getTransferTypesAsMember();
                break;
            }
            case PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM: {
                current = adminGroup.getTransferTypesAsMember();
                break;
            }
            case RECORDS_CREATE: {
                current = adminGroup.getCreateMemberRecordTypes();
                break;
            }
            case RECORDS_DELETE: {
                current = adminGroup.getDeleteMemberRecordTypes();
                break;
            }
            case RECORDS_MODIFY: {
                current = adminGroup.getModifyMemberRecordTypes();
                break;
            }
            case RECORDS_VIEW: {
                current = adminGroup.getViewMemberRecordTypes();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
            }
        }
        return current;
    }

    private static Collection<? extends Entity> getCurrentValues(AdminGroup adminGroup, AdminSystemPermission permission) {
        Collection<Entity> current;
        switch (permission) {
            case ACCOUNTS_INFORMATION: {
                current = adminGroup.getViewInformationOf();
                break;
            }
            case PAYMENTS_CHARGEBACK: {
                current = adminGroup.getChargebackTransferTypes();
                break;
            }
            case PAYMENTS_PAYMENT: {
                current = adminGroup.getTransferTypes();
                break;
            }
            case STATUS_VIEW_CONNECTED_ADMINS: {
                current = adminGroup.getViewConnectedAdminsOf();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
            }
        }
        return current;
    }

    private static Collection<? extends Entity> getCurrentValues(BrokerGroup brokerGroup, BrokerPermission permission) {
        Collection<Entity> current;
        switch (permission) {
            case DOCUMENTS_VIEW: {
                current = brokerGroup.getBrokerDocuments();
                break;
            }
            case MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER: {
                current = brokerGroup.getTransferTypesAsMember();
                break;
            }
            case MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF: {
                current = brokerGroup.getTransferTypesAsMember();
                break;
            }
            case MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM: {
                current = brokerGroup.getTransferTypesAsMember();
                break;
            }
            case MEMBER_RECORDS_CREATE: {
                current = brokerGroup.getBrokerCreateMemberRecordTypes();
                break;
            }
            case MEMBER_RECORDS_DELETE: {
                current = brokerGroup.getBrokerDeleteMemberRecordTypes();
                break;
            }
            case MEMBER_RECORDS_MODIFY: {
                current = brokerGroup.getBrokerModifyMemberRecordTypes();
                break;
            }
            case MEMBER_RECORDS_VIEW: {
                current = brokerGroup.getBrokerMemberRecordTypes();
                break;
            }
            case REPORTS_SHOW_ACCOUNT_INFORMATION: {
                current = brokerGroup.getBrokerCanViewInformationOf();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
            }
        }
        return current;
    }

    private static Collection<? extends Entity> getCurrentValues(MemberGroup memberGroup, MemberPermission permission) {
        Collection<Entity> current;
        switch (permission) {
            case ADS_VIEW: {
                current = memberGroup.getCanViewAdsOfGroups();
                break;
            }
            case DOCUMENTS_VIEW: {
                current = memberGroup.getDocuments();
                break;
            }
            case GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS: {
                current = memberGroup.getCanBuyWithPaymentObligationsFromGroups();
                break;
            }
            case GUARANTEES_ISSUE_CERTIFICATIONS: {
                current = memberGroup.getCanIssueCertificationToGroups();
                break;
            }
            case GUARANTEES_ISSUE_GUARANTEES: {
                current = memberGroup.getGuaranteeTypes();
                break;
            }
            case MESSAGES_SEND_TO_ADMINISTRATION: {
                current = memberGroup.getMessageCategories();
                break;
            }
            case PAYMENTS_CHARGEBACK: {
                current = memberGroup.getChargebackTransferTypes();
                break;
            }
            case PAYMENTS_PAYMENT_TO_MEMBER: {
                current = memberGroup.getTransferTypes();
                break;
            }
            case PAYMENTS_PAYMENT_TO_SELF: {
                current = memberGroup.getTransferTypes();
                break;
            }
            case PAYMENTS_PAYMENT_TO_SYSTEM: {
                current = memberGroup.getTransferTypes();
                break;
            }
            case PAYMENTS_REQUEST: {
                current = memberGroup.getRequestPaymentByChannels();
                break;
            }
            case PROFILE_VIEW: {
                current = memberGroup.getCanViewProfileOfGroups();
                break;
            }
            case REPORTS_SHOW_ACCOUNT_INFORMATION: {
                current = memberGroup.getCanViewInformationOf();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
            }
        }
        return current;
    }

    private static Collection<? extends Entity> getCurrentValues(OperatorGroup operatorGroup, OperatorPermission permission) {
        Collection<Entity> current;
        switch (permission) {
            case ACCOUNT_ACCOUNT_INFORMATION: {
                current = operatorGroup.getCanViewInformationOf();
                break;
            }
            case GUARANTEES_ISSUE_GUARANTEES: {
                current = operatorGroup.getGuaranteeTypes();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported list permission: %1$s.%2$s", permission.getClass().getSimpleName(), permission));
            }
        }
        return current;
    }

    private static String getValue(String name) {
        return name.toLowerCase();
    }

    private static String process(String string) {
        return StringUtils.uncapitalize((String)WordUtils.capitalizeFully((String)string, (char[])NAME_DELIMITERS).replaceAll("\\_", ""));
    }

    static {
        permissionsBySimpleName.put(BasicPermission.class.getSimpleName(), BasicPermission.class);
        permissionsBySimpleName.put(AdminSystemPermission.class.getSimpleName(), AdminSystemPermission.class);
        permissionsBySimpleName.put(AdminAdminPermission.class.getSimpleName(), AdminAdminPermission.class);
        permissionsBySimpleName.put(AdminMemberPermission.class.getSimpleName(), AdminMemberPermission.class);
        permissionsBySimpleName.put(MemberPermission.class.getSimpleName(), MemberPermission.class);
        permissionsBySimpleName.put(OperatorPermission.class.getSimpleName(), OperatorPermission.class);
        permissionsBySimpleName.put(BrokerPermission.class.getSimpleName(), BrokerPermission.class);
    }
}

