/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.binding;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;

public class BeanBinder<T>
extends DataBinder<T> {
    private static final long serialVersionUID = 6669808609710330346L;
    private Map<String, DataBinder<?>> mappings = new LinkedHashMap();

    public static <T> BeanBinder<T> instance(Class<T> beanClass) {
        return BeanBinder.instance(beanClass, null);
    }

    public static <T> BeanBinder<T> instance(Class<T> beanClass, String path) {
        BeanBinder<T> binder = new BeanBinder<T>();
        binder.setType(beanClass);
        binder.setPath(path);
        return binder;
    }

    public Map<String, DataBinder<?>> getMappings() {
        return this.mappings;
    }

    @Override
    public T read(Object object) {
        if (object == null) {
            return null;
        }
        Object bean = ClassHelper.instantiate(this.getType());
        this.readInto(bean, object, false);
        return bean;
    }

    @Override
    public String readAsString(Object object) {
        if (object == null) {
            return "null";
        }
        JSONObject json = new JSONObject();
        this.writeAsString(json, object);
        return json.toJSONString();
    }

    @Override
    public T readFromString(Object object) {
        if (object == null) {
            return null;
        }
        Object bean = ClassHelper.instantiate(this.getType());
        this.readInto(bean, object, true);
        return bean;
    }

    public void readInto(Object bean, Object object, boolean fromString) {
        object = PropertyHelper.get(object, this.getPath());
        for (Map.Entry<String, DataBinder<?>> entry : this.mappings.entrySet()) {
            String beanProperty = entry.getKey();
            DataBinder<?> nestedBinder = entry.getValue();
            Object resolvedObject = object;
            if (StringUtils.isEmpty((String)nestedBinder.getPath())) {
                resolvedObject = PropertyHelper.get(object, nestedBinder.getPath());
            }
            Object value = fromString ? nestedBinder.readFromString(resolvedObject) : nestedBinder.read(resolvedObject);
            PropertyHelper.set(bean, beanProperty, CoercionHelper.coerce(nestedBinder.getType(), value));
        }
    }

    public void registerBinder(String property, DataBinder<?> binder) {
        this.mappings.put(property, binder);
    }

    public void setMappings(Map<String, DataBinder<?>> mappings) {
        this.mappings = mappings;
    }

    @Override
    public void write(Object object, T value) {
        if (object == null) {
            return;
        }
        this.doWrite(object, value, false);
    }

    @Override
    public void writeAsString(Object object, Object value) {
        if (object == null) {
            return;
        }
        if ("".equals(value)) {
            value = null;
        }
        this.doWrite(object, value, true);
    }

    private void doWrite(Object bean, Object value, boolean asString) {
        Object resolved = PropertyHelper.get(bean, this.getPath());
        if (resolved == null) {
            resolved = ClassHelper.instantiate(this.getType());
            PropertyHelper.set(bean, this.getPath(), resolved);
        }
        for (Map.Entry<String, DataBinder<?>> entry : this.mappings.entrySet()) {
            String beanProperty = entry.getKey();
            DataBinder<?> nestedBinder = entry.getValue();
            String current = null;
            if (asString) {
                if (nestedBinder instanceof PropertyBinder) {
                    current = nestedBinder.readAsString(value);
                } else {
                    Object nestedValue = PropertyHelper.get(value, beanProperty);
                    Object nestedBean = PropertyHelper.get(resolved, beanProperty);
                    if (nestedBean == null) {
                        HashMap hashMap = nestedBean = nestedBinder instanceof BeanBinder ? new HashMap() : ClassHelper.instantiate(nestedBinder.getType());
                    }
                    if (nestedValue != null) {
                        nestedBinder.writeAsString(resolved, nestedValue);
                    }
                    current = nestedBean;
                }
            } else {
                current = (String)nestedBinder.read(value);
            }
            PropertyHelper.set(resolved, beanProperty, current);
        }
    }
}

