/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import org.apache.commons.collections.IteratorUtils;

public class BeanCollectionBinder<T>
extends DataBinder<Collection<T>> {
    private static final long serialVersionUID = -2345152330629764092L;
    private BeanBinder<T> elementBinder;
    private Class<?> collectionType = ArrayList.class;

    public static <T> BeanCollectionBinder<T> instance(BeanBinder<T> elementBinder) {
        return BeanCollectionBinder.instance(elementBinder, null, null);
    }

    public static <T> BeanCollectionBinder<T> instance(BeanBinder<T> elementBinder, Class<?> collectionType) {
        return BeanCollectionBinder.instance(elementBinder, collectionType, null);
    }

    public static <T> BeanCollectionBinder<T> instance(BeanBinder<T> elementBinder, Class<?> collectionType, String path) {
        BeanCollectionBinder<T> binder = new BeanCollectionBinder<T>(elementBinder);
        binder.setPath(path);
        binder.setCollectionType(collectionType);
        return binder;
    }

    public static <T> BeanCollectionBinder<T> instance(BeanBinder<T> elementBinder, String path) {
        return BeanCollectionBinder.instance(elementBinder, null, path);
    }

    public BeanCollectionBinder() {
        this(null);
    }

    public BeanCollectionBinder(BeanBinder<T> elementBinder) {
        this.setElementBinder(elementBinder);
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public DataBinder<T> getElementBinder() {
        return this.elementBinder;
    }

    @Override
    public Class<Collection<T>> getType() {
        Class<Collection<T>> clazz = ClassHelper.cast(Collection.class);
        return clazz;
    }

    @Override
    public Collection<T> read(Object object) {
        Collection ret = this.instantiateCollection();
        this.readInto(ret, object, false);
        return ret;
    }

    @Override
    public String readAsString(Object object) {
        this.validateElementBinder();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator it = IteratorUtils.getIterator((Object)object);
        while (it.hasNext()) {
            Object value = it.next();
            sb.append(this.elementBinder.readAsString(value));
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Collection<T> readFromString(Object object) {
        this.validateElementBinder();
        Collection ret = this.instantiateCollection();
        this.readInto(ret, object, true);
        return ret;
    }

    public void readInto(Collection<T> collection, Object object, boolean asString) {
        this.validateElementBinder();
        Object bean = PropertyHelper.get(object, this.getPath());
        Map<String, DataBinder<?>> mappings = this.elementBinder.getMappings();
        if (mappings.isEmpty() || bean == null) {
            return;
        }
        LinkedHashMap<String, Iterator> iterators = new LinkedHashMap<String, Iterator>();
        for (Map.Entry<String, DataBinder<?>> entry : mappings.entrySet()) {
            String name = entry.getKey();
            Iterator iterator = IteratorUtils.getIterator(PropertyHelper.get(bean, name));
            iterators.put(name, iterator);
        }
        while (true) {
            boolean hasData = true;
            HashMap current = new HashMap();
            hasData = false;
            for (Map.Entry entry : iterators.entrySet()) {
                String name = (String)entry.getKey();
                Iterator iterator = (Iterator)entry.getValue();
                if (!iterator.hasNext()) continue;
                hasData = true;
                current.put(name, iterator.next());
            }
            if (!hasData) break;
            collection.add(asString ? this.elementBinder.readFromString(current) : this.elementBinder.read(current));
        }
    }

    public void setCollectionType(Class<?> collectionType) {
        this.collectionType = collectionType == null ? ArrayList.class : collectionType;
    }

    public void setElementBinder(BeanBinder<T> elementBinder) {
        this.elementBinder = elementBinder;
    }

    @Override
    public void write(Object object, Collection<T> values) {
        this.validateElementBinder();
        this.doWrite(object, values, false);
    }

    @Override
    public void writeAsString(Object object, Object value) {
        this.validateElementBinder();
        Collection<String> values = this.instantiateCollection();
        Iterator it = IteratorUtils.getIterator((Object)object);
        while (it.hasNext()) {
            Object current = it.next();
            values.add(this.elementBinder.readAsString(current));
        }
        this.doWrite(object, values, true);
    }

    private void doWrite(Object object, Collection<?> values, boolean asString) {
        Map<String, DataBinder<?>> mappings = this.elementBinder.getMappings();
        if (mappings.isEmpty()) {
            return;
        }
        HashMap map = new HashMap();
        for (Object obj : values) {
            for (Map.Entry<String, DataBinder<?>> entry : mappings.entrySet()) {
                String name = entry.getKey();
                DataBinder<?> nestedBinder = entry.getValue();
                String path = nestedBinder.getPath();
                ArrayList propValues = (ArrayList)map.get(path);
                if (propValues == null) {
                    propValues = new ArrayList();
                    map.put(path, propValues);
                }
                propValues.add(PropertyHelper.get(obj, name));
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            PropertyHelper.set(object, (String)entry.getKey(), entry.getValue());
        }
    }

    private <E> Collection<E> instantiateCollection() {
        return (Collection)ClassHelper.instantiate(this.collectionType);
    }

    private void validateElementBinder() {
        if (this.elementBinder == null) {
            throw new IllegalStateException("null.element-binder");
        }
    }
}

