/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.binding;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Map;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.query.PageParameters;

public final class DataBinderHelper {
    private static final Class<Map<String, Object>> MAP_CLASS = ClassHelper.cast(Map.class);

    public static BeanBinder<Map<String, Object>> accountTypeBinder() {
        BeanBinder<Map<String, Object>> binder = BeanBinder.instance(MAP_CLASS);
        binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        binder.registerBinder("currencyId", PropertyBinder.instance(Currency.class, "currency"));
        return binder;
    }

    public static BeanBinder<Amount> amountConverter(String name, LocalSettings localSettings) {
        BeanBinder<Amount> binder = BeanBinder.instance(Amount.class, name);
        binder.registerBinder("type", PropertyBinder.instance(Amount.Type.class, "type"));
        binder.registerBinder("value", PropertyBinder.instance(BigDecimal.class, "value", localSettings.getNumberConverter()));
        return binder;
    }

    public static BeanBinder<Map<String, Object>> elementBinder() {
        return DataBinderHelper.elementBinder(null);
    }

    public static BeanBinder<Map<String, Object>> elementBinder(String path) {
        BeanBinder<Map<String, Object>> binder = DataBinderHelper.simpleElementBinder(path);
        binder.registerBinder("group", PropertyBinder.instance(String.class, "group.name"));
        binder.registerBinder("groupId", PropertyBinder.instance(String.class, "group.id"));
        binder.registerBinder("email", PropertyBinder.instance(String.class, "email"));
        return binder;
    }

    public static BeanBinder<Amount> highPrecisionAmountConverter(String name, LocalSettings localSettings) {
        BeanBinder<Amount> binder = BeanBinder.instance(Amount.class, name);
        binder.registerBinder("type", PropertyBinder.instance(Amount.Type.class, "type"));
        binder.registerBinder("value", PropertyBinder.instance(BigDecimal.class, "value", localSettings.getHighPrecisionConverter()));
        return binder;
    }

    public static BeanBinder<Map<String, Object>> loanParametersBinder(LocalSettings settings) {
        BeanBinder<Map<String, Object>> binder = BeanBinder.instance(MAP_CLASS);
        binder.registerBinder("loanType", PropertyBinder.instance(Loan.Type.class, "type"));
        binder.registerBinder("expirationDailyInterest", PropertyBinder.instance(Amount.class, "expirationDailyInterestAmount", settings.getAmountConverter()));
        binder.registerBinder("expirationFee", PropertyBinder.instance(Amount.class, "expirationFee", settings.getAmountConverter()));
        binder.registerBinder("grantFee", PropertyBinder.instance(Amount.class, "grantFee", settings.getAmountConverter()));
        binder.registerBinder("monthlyInterest", PropertyBinder.instance(Amount.class, "monthlyInterestAmount", settings.getAmountConverter()));
        binder.registerBinder("repaymentDays", PropertyBinder.instance(Integer.class, "repaymentDays"));
        return binder;
    }

    public static BeanBinder<NamedPeriod> namedPeriodBinder(LocalSettings localSettings, String name) {
        BeanBinder<NamedPeriod> binder = BeanBinder.instance(NamedPeriod.class, name);
        binder.registerBinder("begin", PropertyBinder.instance(Calendar.class, "begin", localSettings.getDateConverter()));
        binder.registerBinder("end", PropertyBinder.instance(Calendar.class, "end", localSettings.getDateConverter()));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        return binder;
    }

    public static BeanBinder<PageParameters> pageBinder() {
        BeanBinder<PageParameters> binder = BeanBinder.instance(PageParameters.class, "pageParameters");
        binder.registerBinder("currentPage", PropertyBinder.instance(Integer.TYPE, "currentPage"));
        return binder;
    }

    public static BeanBinder<Period> periodBinder(LocalSettings localSettings, String name) {
        BeanBinder<Period> binder = BeanBinder.instance(Period.class, name);
        binder.registerBinder("begin", PropertyBinder.instance(Calendar.class, "begin", localSettings.getDateConverter()));
        binder.registerBinder("end", PropertyBinder.instance(Calendar.class, "end", localSettings.getDateConverter()));
        return binder;
    }

    public static BeanBinder<RangeConstraint> rangeConstraintBinder(String name) {
        BeanBinder<RangeConstraint> binder = BeanBinder.instance(RangeConstraint.class, name);
        binder.registerBinder("min", PropertyBinder.instance(Integer.TYPE, "min"));
        binder.registerBinder("max", PropertyBinder.instance(Integer.TYPE, "max"));
        return binder;
    }

    public static BeanBinder<Period> rawPeriodBinder(LocalSettings localSettings, String name) {
        BeanBinder<Period> binder = BeanBinder.instance(Period.class, name);
        binder.registerBinder("begin", PropertyBinder.instance(Calendar.class, "begin", localSettings.getRawDateConverter()));
        binder.registerBinder("end", PropertyBinder.instance(Calendar.class, "end", localSettings.getRawDateConverter()));
        return binder;
    }

    public static BeanBinder<Map<String, Object>> simpleElementBinder() {
        return DataBinderHelper.simpleElementBinder(null);
    }

    public static BeanBinder<Map<String, Object>> simpleElementBinder(String path) {
        BeanBinder<Map<String, Object>> binder = BeanBinder.instance(MAP_CLASS, path);
        binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        binder.registerBinder("username", PropertyBinder.instance(String.class, "user.username"));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        return binder;
    }

    public static BeanBinder<TimePeriod> timePeriodBinder(String name) {
        BeanBinder<TimePeriod> binder = BeanBinder.instance(TimePeriod.class, name);
        binder.registerBinder("field", PropertyBinder.instance(TimePeriod.Field.class, "field"));
        binder.registerBinder("number", PropertyBinder.instance(Integer.TYPE, "number"));
        return binder;
    }

    public static BeanBinder<Map<String, Object>> transferTypeBinder() {
        Class type = ClassHelper.cast(Map.class);
        BeanBinder<Map<String, Object>> binder = BeanBinder.instance(type);
        binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        return binder;
    }
}

