/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.binding;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.PropertyUtils;

public class MapBean
extends HashMap<String, Object>
implements DynaBean {
    private static final long serialVersionUID = -3168550184931640176L;
    private final boolean isArray;
    private Map<String, Class<?>> propertyTypes = new HashMap();

    public MapBean(boolean isArray, String ... properties) {
        this.isArray = isArray;
        if (properties != null) {
            for (String name : properties) {
                this.propertyTypes.put(name, isArray ? Object[].class : Object.class);
            }
        }
    }

    public MapBean(String ... properties) {
        this(false, properties);
    }

    public boolean contains(String name, String key) {
        return this.get(name, key) != null;
    }

    @Override
    public Object get(Object key) {
        String name = (String)key;
        if (!this.propertyTypes.containsKey(key)) {
            this.propertyTypes.put(name, this.isArray ? Object[].class : Object.class);
        }
        return super.get(key);
    }

    public Object get(String name) {
        return this.get((Object)name);
    }

    public Object get(String name, int index) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof List) {
                return ((List)value).get(index);
            }
            if (value.getClass().isArray()) {
                return Array.get(value, index);
            }
        }
        return null;
    }

    public Object get(String name, String key) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof DynaBean) {
                return ((DynaBean)value).get(key);
            }
            try {
                return PropertyUtils.getProperty((Object)value, (String)key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public DynaClass getDynaClass() {
        LazyDynaClass dynaClass = new LazyDynaClass();
        for (Map.Entry<String, Class<?>> entry : this.propertyTypes.entrySet()) {
            dynaClass.add(entry.getKey(), entry.getValue());
        }
        return dynaClass;
    }

    @Override
    public Object put(String key, Object value) {
        String name = key;
        if (!this.propertyTypes.containsKey(key)) {
            this.propertyTypes.put(name, this.isArray ? Object[].class : Object.class);
        }
        return super.put(key, value);
    }

    public void remove(String name, String key) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof DynaBean) {
                ((DynaBean)value).set(key, null);
            } else {
                try {
                    PropertyUtils.setProperty((Object)value, (String)key, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void set(String name, int index, Object value) {
        Object bean = this.get(name);
        if (bean != null) {
            if (bean instanceof List) {
                ((List)bean).set(index, value);
            } else if (value.getClass().isArray()) {
                Array.set(bean, index, value);
            }
        }
    }

    public void set(String name, Object value) {
        this.put(name, value);
    }

    public void set(String name, String key, Object value) {
        Object bean = this.get(name);
        if (bean != null) {
            if (bean instanceof DynaBean) {
                ((DynaBean)bean).set(key, value);
            } else {
                try {
                    PropertyUtils.setProperty((Object)bean, (String)key, (Object)value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void setArray(String name) {
        this.setType(name, Object[].class);
    }

    public void setType(String name, Class<?> type) {
        this.propertyTypes.put(name, type);
    }
}

