/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;

public class MapBinder<K, V>
extends DataBinder<Map<K, V>> {
    private static final long serialVersionUID = -234513355349764092L;
    private DataBinder<K> keyBinder;
    private DataBinder<V> valueBinder;

    public static <K, V> MapBinder<K, V> instance(DataBinder<K> keyBinder, DataBinder<V> valueBinder) {
        return MapBinder.instance(keyBinder, valueBinder, null);
    }

    public static <K, V> MapBinder<K, V> instance(DataBinder<K> keyBinder, DataBinder<V> valueBinder, String path) {
        MapBinder<K, V> binder = new MapBinder<K, V>(keyBinder, valueBinder);
        binder.setPath(path);
        return binder;
    }

    public MapBinder() {
        Class clazz = ClassHelper.cast(Map.class);
        this.setType(clazz);
    }

    public MapBinder(DataBinder<K> keyBinder, DataBinder<V> valueBinder) {
        this();
        this.setKeyBinder(keyBinder);
        this.setValueBinder(valueBinder);
    }

    public DataBinder<K> getKeyBinder() {
        return this.keyBinder;
    }

    public DataBinder<V> getValueBinder() {
        return this.valueBinder;
    }

    @Override
    public Map<K, V> read(Object object) {
        LinkedHashMap ret = new LinkedHashMap();
        this.readInto(ret, object, false);
        return ret;
    }

    @Override
    public String readAsString(Object object) {
        this.validateNestedBinders();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Iterator it = IteratorUtils.getIterator((Object)object);
        while (it.hasNext()) {
            Object value = it.next();
            sb.append(this.keyBinder.readAsString(value)).append('=').append(this.valueBinder.readAsString(value));
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Map<K, V> readFromString(Object object) {
        this.validateNestedBinders();
        LinkedHashMap ret = new LinkedHashMap();
        this.readInto(ret, object, true);
        return ret;
    }

    public void readInto(Map<K, V> map, Object object, boolean asString) {
        this.validateNestedBinders();
        Iterator elements = null;
        Object bean = PropertyHelper.get(object, this.getPath());
        int maxSize = 0;
        ArrayList keyValues = new ArrayList();
        ArrayList valueValues = new ArrayList();
        Object obj = PropertyHelper.get(bean, this.keyBinder.getPath());
        CollectionUtils.addAll(keyValues, (Iterator)IteratorUtils.getIterator(obj));
        obj = PropertyHelper.get(bean, this.valueBinder.getPath());
        CollectionUtils.addAll(valueValues, (Iterator)IteratorUtils.getIterator(obj));
        maxSize = Math.max(keyValues.size(), valueValues.size());
        ArrayList list = new ArrayList();
        for (int i = 0; i < maxSize; ++i) {
            HashMap current = new HashMap();
            current.put(this.keyBinder.getPath(), keyValues.get(i));
            current.put(this.valueBinder.getPath(), valueValues.get(i));
            list.add(current);
        }
        elements = list.iterator();
        if (elements != null) {
            while (elements.hasNext()) {
                Object current = elements.next();
                map.put(asString ? this.keyBinder.readFromString(current) : this.keyBinder.read(current), asString ? this.valueBinder.readFromString(current) : this.valueBinder.read(current));
            }
        }
    }

    public void setKeyBinder(DataBinder<K> keyBinder) {
        this.keyBinder = keyBinder;
    }

    public void setValueBinder(DataBinder<V> valueBinder) {
        this.valueBinder = valueBinder;
    }

    @Override
    public void write(Object object, Map<K, V> values) {
        this.validateNestedBinders();
        this.doWrite(object, values);
    }

    @Override
    public void writeAsString(Object object, Object value) {
        this.validateNestedBinders();
        HashMap<String, String> values = new HashMap<String, String>();
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String keyAsString = this.keyBinder.readAsString(Collections.singletonMap(this.keyBinder.getPath(), entry.getKey()));
                String valueAsString = this.valueBinder.readAsString(Collections.singletonMap(this.valueBinder.getPath(), entry.getValue()));
                values.put(keyAsString, valueAsString);
            }
        } else {
            Iterator it = IteratorUtils.getIterator((Object)value);
            while (it.hasNext()) {
                Object current = it.next();
                values.put(this.keyBinder.readAsString(current), this.valueBinder.readAsString(current));
            }
        }
        this.doWrite(object, values);
    }

    private void doWrite(Object object, Map<?, ?> map) {
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            keys.add(entry.getKey());
            values.add(entry.getValue());
        }
        Object bean = PropertyHelper.get(object, this.getPath());
        if (bean == null) {
            bean = new HashMap();
            PropertyHelper.set(object, this.getPath(), bean);
        }
        PropertyHelper.set(bean, this.keyBinder.getPath(), keys);
        PropertyHelper.set(bean, this.valueBinder.getPath(), values);
    }

    private void validateNestedBinders() {
        if (this.keyBinder == null) {
            throw new IllegalStateException("null.key-binder");
        }
        if (this.valueBinder == null) {
            throw new IllegalStateException("null.value-binder");
        }
    }
}

