/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.binding;

import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.ConversionException;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.conversion.StringTrimmerConverter;

public class PropertyBinder<T>
extends DataBinder<T> {
    private static final long serialVersionUID = -2107269320674334749L;
    private Converter<T> converter;

    public static <T> PropertyBinder<T> instance(Class<T> propertyType, String propertyName) {
        StringTrimmerConverter converter = null;
        if (String.class.isAssignableFrom(propertyType)) {
            converter = new StringTrimmerConverter();
        }
        return PropertyBinder.instance(propertyType, propertyName, converter);
    }

    public static <T> PropertyBinder<T> instance(Class<T> propertyType, String propertyName, Converter<T> converter) {
        PropertyBinder<T> binder = new PropertyBinder<T>();
        binder.setPath(propertyName);
        binder.setType(propertyType);
        binder.setConverter(converter);
        return binder;
    }

    public Converter<T> getConverter() {
        return this.converter;
    }

    @Override
    public T read(Object object) {
        return CoercionHelper.coerce(this.getType(), PropertyHelper.get(object, this.getPath()));
    }

    @Override
    public String readAsString(Object object) {
        try {
            return PropertyHelper.getAsString(this.read(object), this.getConverter());
        }
        catch (ConversionException e) {
            return null;
        }
    }

    @Override
    public T readFromString(Object object) {
        Object objectValue = PropertyHelper.get(object, this.getPath());
        String value = CoercionHelper.coerce(String.class, objectValue);
        try {
            return PropertyHelper.getAsObject(this.getType(), value, this.getConverter());
        }
        catch (ConversionException e) {
            return null;
        }
    }

    public void setConverter(Converter<T> converter) {
        this.converter = converter;
    }

    @Override
    public void write(Object object, T value) {
        PropertyHelper.set(object, this.getPath(), CoercionHelper.coerce(this.getType(), value));
    }

    @Override
    public void writeAsString(Object object, Object value) {
        this.write(object, PropertyHelper.getAsObject(this.getType(), CoercionHelper.coerce(String.class, value), this.getConverter()));
    }
}

