/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.collections.IteratorUtils;

public class SimpleCollectionBinder<T>
extends DataBinder<Collection<T>> {
    private static final long serialVersionUID = -2345152330629764092L;
    private Class<T> elementType;
    private Class<?> collectionType = ArrayList.class;
    private Converter<T> converter;

    public static <T> SimpleCollectionBinder<T> instance(Class<T> elementType) {
        return SimpleCollectionBinder.instance(elementType, null, null, null);
    }

    public static <T> SimpleCollectionBinder<T> instance(Class<T> elementType, Class<?> collectionType) {
        return SimpleCollectionBinder.instance(elementType, collectionType, null, null);
    }

    public static <T> SimpleCollectionBinder<T> instance(Class<T> elementType, Class<?> collectionType, Converter<T> converter) {
        return SimpleCollectionBinder.instance(elementType, collectionType, null, converter);
    }

    public static <T> SimpleCollectionBinder<T> instance(Class<T> elementType, Class<?> collectionType, String path) {
        return SimpleCollectionBinder.instance(elementType, collectionType, path, null);
    }

    public static <T> SimpleCollectionBinder<T> instance(Class<T> elementType, Class<?> collectionType, String path, Converter<T> converter) {
        SimpleCollectionBinder<T> binder = new SimpleCollectionBinder<T>();
        binder.setElementType(elementType);
        binder.setCollectionType(collectionType);
        binder.setPath(path);
        binder.setConverter(converter);
        return binder;
    }

    public static <T> SimpleCollectionBinder<T> instance(Class<T> elementType, Converter<T> converter) {
        return SimpleCollectionBinder.instance(elementType, null, null, converter);
    }

    public static <T> SimpleCollectionBinder<T> instance(Class<T> elementType, String path) {
        return SimpleCollectionBinder.instance(elementType, null, path, null);
    }

    public static <T> SimpleCollectionBinder<T> instance(Class<T> elementType, String path, Converter<T> converter) {
        return SimpleCollectionBinder.instance(elementType, null, path, converter);
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public Converter<T> getConverter() {
        return this.converter;
    }

    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public Class<Collection<T>> getType() {
        Class<Collection<T>> clazz = ClassHelper.cast(this.collectionType == null ? Collection.class : this.collectionType);
        return clazz;
    }

    @Override
    public Collection<T> read(Object object) {
        Collection ret = this.instantiateCollection();
        this.readInto(ret, object, false);
        return ret;
    }

    @Override
    public String readAsString(Object object) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Converter<T> converter = this.resolveConverter();
        Iterator it = IteratorUtils.getIterator((Object)object);
        while (it.hasNext()) {
            Object value = it.next();
            T baseValue = CoercionHelper.coerce(this.elementType, value);
            sb.append('\"').append(converter.toString(baseValue)).append('\"');
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Collection<T> readFromString(Object object) {
        Collection ret = this.instantiateCollection();
        this.readInto(ret, object, true);
        return ret;
    }

    public void readInto(Collection<T> collection, Object object, boolean asString) {
        List list = CoercionHelper.coerce(List.class, PropertyHelper.get(object, this.getPath()));
        if (list != null) {
            Converter<T> converter = this.resolveConverter();
            for (Object current : list) {
                T value;
                if (current == null || (value = asString ? converter.valueOf(current.toString()) : CoercionHelper.coerce(this.elementType, current)) == null) continue;
                collection.add(value);
            }
        }
    }

    public void setCollectionType(Class<?> collectionType) {
        this.collectionType = collectionType == null ? ArrayList.class : collectionType;
    }

    public void setConverter(Converter<T> converter) {
        this.converter = converter;
    }

    public void setElementType(Class<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    public void write(Object object, Collection<T> values) {
        this.doWrite(object, values, false);
    }

    @Override
    public void writeAsString(Object object, Object value) {
        this.doWrite(object, CoercionHelper.coerce(List.class, value), true);
    }

    private void doWrite(Object object, Collection<?> values, boolean asString) {
        if (values == null) {
            return;
        }
        Collection<String> collection = this.instantiateCollection();
        Converter<?> converter = this.resolveConverter();
        for (Object value : values) {
            String result = asString ? converter.toString(value) : CoercionHelper.coerce(this.elementType, value);
            if (result == null) continue;
            collection.add(result);
        }
        PropertyHelper.set(object, this.getPath(), collection);
    }

    private <E> Collection<E> instantiateCollection() {
        return (Collection)ClassHelper.instantiate(this.collectionType);
    }

    private Converter<T> resolveConverter() {
        Converter<T> converter = this.converter == null ? CoercionConverter.instance(this.elementType) : this.converter;
        return converter;
    }
}

