/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import org.springframework.beans.factory.DisposableBean;

public abstract class BaseCacheManager
implements CacheManager,
DisposableBean {
    protected final Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();

    public void destroy() throws Exception {
        for (Cache cache : this.caches.values()) {
            try {
                cache.shutdown();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public final synchronized Cache getCache(String name) {
        Cache cache = this.caches.get(name);
        if (cache == null) {
            cache = this.createCache(name);
            this.caches.put(name, cache);
        }
        return cache;
    }

    protected abstract Cache createCache(String var1);
}

