/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.cache;

import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.NotificationScope;
import nl.strohalm.cyclos.utils.CollectionHelper;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheListener;
import nl.strohalm.cyclos.utils.cache.CacheListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EhCacheCache
implements Cache {
    private static final Log LOG = LogFactory.getLog((String)EhCacheCache.class.getName());
    private final Ehcache ehcache;

    public EhCacheCache(Ehcache ehcache) {
        this.ehcache = ehcache;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating EhCacheCache <" + this.getName() + ">"));
        }
    }

    @Override
    public synchronized boolean addListener(CacheListener listener) {
        EhCacheListenerAdapter ehCacheListener = new EhCacheListenerAdapter(listener);
        return this.ehcache.getCacheEventNotificationService().registerListener((CacheEventListener)ehCacheListener, NotificationScope.ALL);
    }

    @Override
    public void clear() {
        this.ehcache.removeAll();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cache <" + this.getName() + "> cleared"));
        }
    }

    @Override
    public <T> T get(Serializable key, CacheCallback callback) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cache <" + this.getName() + "> miss for key <" + key + ">"));
            }
            element = new Element((Object)key, callback.retrieve());
            this.ehcache.put(element);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cache <" + this.getName() + "> hit for key <" + key + ">"));
        }
        return CollectionHelper.defensiveCopy(element.getValue());
    }

    @Override
    public String getName() {
        return this.ehcache.getName();
    }

    @Override
    public <T> T remove(Serializable key) {
        Element element = this.ehcache.get(key);
        if (element != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cache <" + this.getName() + "> removing key <" + key + ">"));
            }
            this.ehcache.remove(key);
            return (T)element.getValue();
        }
        return null;
    }

    @Override
    public void shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Shutting down cache <" + this.getName() + ">"));
        }
        this.ehcache.getCacheManager().removeCache(this.ehcache.getName());
    }

    private class EhCacheListenerAdapter
    extends CacheListenerAdapter
    implements CacheEventListener {
        private EhCacheListenerAdapter(CacheListener listener) {
            super(listener);
        }

        public void dispose() {
        }

        public void notifyElementEvicted(Ehcache cache, Element element) {
            this.listener.onValueRemoved(EhCacheCache.this, element.getKey(), element.getValue());
        }

        public void notifyElementExpired(Ehcache cache, Element element) {
            this.listener.onValueRemoved(EhCacheCache.this, element.getKey(), element.getValue());
        }

        public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
            this.listener.onValueAdded(EhCacheCache.this, element.getKey(), element.getValue());
        }

        public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
            this.listener.onValueRemoved(EhCacheCache.this, element.getKey(), element.getValue());
        }

        public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
            this.listener.onValueAdded(EhCacheCache.this, element.getKey(), element.getValue());
        }

        public void notifyRemoveAll(Ehcache cache) {
            this.listener.onCacheCleared(EhCacheCache.this);
        }
    }
}

