/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.cache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import nl.strohalm.cyclos.utils.cache.BaseCacheManager;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.EhCacheCache;
import org.apache.commons.lang.reflect.FieldUtils;
import org.hibernate.cache.RegionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class EhCacheCacheManager
extends BaseCacheManager
implements InitializingBean,
DisposableBean {
    private CacheManager ehCacheManager;
    private SessionFactoryImplementor sessionFactory;
    private boolean cleanUpEhCache;

    public void afterPropertiesSet() throws Exception {
        try {
            RegionFactory regionFactory = this.sessionFactory.getSettings().getRegionFactory();
            this.ehCacheManager = (CacheManager)FieldUtils.readField((Object)regionFactory, (String)"manager", (boolean)true);
        }
        catch (Exception e) {
            this.ehCacheManager = new CacheManager();
            this.cleanUpEhCache = true;
        }
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        if (this.cleanUpEhCache) {
            this.ehCacheManager.shutdown();
        }
    }

    public void setSessionFactory(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected Cache createCache(String name) {
        Ehcache ehcache = this.ehCacheManager.getEhcache(name);
        if (ehcache == null) {
            this.ehCacheManager.addCache(name);
            ehcache = this.ehCacheManager.getEhcache(name);
        }
        return new EhCacheCache(ehcache);
    }
}

