/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.cache.ehcache;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import nl.strohalm.cyclos.utils.CurrentApplicationContext;
import nl.strohalm.cyclos.utils.HazelcastHelper;
import nl.strohalm.cyclos.utils.cache.ehcache.CacheEvictionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class HazelcastCacheManagerPeerProvider
implements CacheManagerPeerProvider,
MessageListener<CacheEvictionEvent> {
    public static final String SCHEME_NAME = "Hazelcast";
    private static final Log LOG = LogFactory.getLog(HazelcastCacheManagerPeerProvider.class);
    private final CacheManager cacheManager;
    private ITopic<CacheEvictionEvent> topic;
    private Status status = Status.STATUS_UNINITIALISED;

    public static HazelcastCacheManagerPeerProvider getCachePeerProvider(CacheManager cacheManager) {
        CacheManagerPeerProvider provider = cacheManager.getCacheManagerPeerProvider(SCHEME_NAME);
        if (provider == null) {
            LOG.warn((Object)"No CacheManagerPeerProvider registered for Hazelcast scheme.");
            return null;
        }
        if (!(provider instanceof HazelcastCacheManagerPeerProvider)) {
            LOG.warn((Object)("CacheManagerPeerProvider for scheme Hazelcast cannot be cast to " + HazelcastCacheManagerPeerProvider.class.getName()));
            return null;
        }
        return (HazelcastCacheManagerPeerProvider)provider;
    }

    public static HazelcastCacheManagerPeerProvider getCachePeerProvider(Ehcache cache) {
        CacheManager cacheManager = cache.getCacheManager();
        return HazelcastCacheManagerPeerProvider.getCachePeerProvider(cacheManager);
    }

    public static ITopic<CacheEvictionEvent> getTopic(Ehcache cache) {
        return HazelcastCacheManagerPeerProvider.getCachePeerProvider(cache).getTopic();
    }

    public HazelcastCacheManagerPeerProvider(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void dispose() throws CacheException {
        this.status = Status.STATUS_SHUTDOWN;
    }

    public String getScheme() {
        return SCHEME_NAME;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public ITopic<CacheEvictionEvent> getTopic() {
        return this.topic;
    }

    public void init() {
        ApplicationContext applicationContext = CurrentApplicationContext.CURRENT.get();
        HazelcastInstance hazelcastInstance = HazelcastHelper.getHazelcastInstance(applicationContext);
        this.topic = hazelcastInstance.getTopic("cyclos.EhCacheEvictionReplication");
        this.topic.addMessageListener((MessageListener)this);
        this.status = Status.STATUS_ALIVE;
        LOG.info((Object)"EhCache replication has started using Hazelcast");
    }

    public List<CachePeer> listRemoteCachePeers(Ehcache cache) throws CacheException {
        return Collections.emptyList();
    }

    public void onMessage(Message<CacheEvictionEvent> message) {
        Ehcache cache;
        CacheEvictionEvent event = (CacheEvictionEvent)message.getMessageObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received cache eviction event: " + event));
        }
        if ((cache = this.cacheManager.getEhcache(event.getName())) != null) {
            Object key = event.getKey();
            if (key == null) {
                cache.removeAll(true);
            } else {
                cache.remove(key, true);
            }
        }
    }

    public void registerPeer(String rmiUrl) {
    }

    public void unregisterPeer(String rmiUrl) {
    }
}

