/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.cache.ehcache;

import com.hazelcast.core.ITopic;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;
import nl.strohalm.cyclos.utils.cache.ehcache.CacheEvictionEvent;
import nl.strohalm.cyclos.utils.cache.ehcache.HazelcastCacheManagerPeerProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HazelcastCacheReplicator
implements CacheReplicator {
    private static final Log LOG = LogFactory.getLog(HazelcastCacheReplicator.class);
    private boolean alive;

    public boolean alive() {
        return this.alive;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void dispose() {
        this.alive = false;
    }

    public boolean isReplicateUpdatesViaCopy() {
        return false;
    }

    public boolean notAlive() {
        return !this.alive;
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        this.publish(cache, element.getKey());
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this.publish(cache, element.getKey());
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        this.publish(cache, element.getKey());
    }

    public void notifyRemoveAll(Ehcache cache) {
        this.publish(cache, null);
    }

    private void publish(Ehcache cache, Object key) {
        CacheEvictionEvent event = new CacheEvictionEvent(cache.getName(), key);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Publishing cache eviction event: " + event));
        }
        ITopic<CacheEvictionEvent> topic = HazelcastCacheManagerPeerProvider.getTopic(cache);
        try {
            topic.publish((Object)event);
        }
        catch (Exception e) {
            LOG.warn((Object)("Couldn't publish cache eviction event: " + event), (Throwable)e);
        }
    }
}

