/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;

public class AccountOwnerConverter
implements Converter<AccountOwner> {
    private static final long serialVersionUID = -4876497836403187578L;
    private static final AccountOwnerConverter INSTANCE = new AccountOwnerConverter(false);
    private static final AccountOwnerConverter ZERO_IS_SYSTEM_INSTANCE = new AccountOwnerConverter(true);
    private static final ReferenceConverter<Member> REFERENCE_CONVERTER = ReferenceConverter.instance(Member.class);
    private final boolean zeroIsSystem;

    public static AccountOwnerConverter instance() {
        return INSTANCE;
    }

    public static AccountOwnerConverter zeroIsSystemInstance() {
        return ZERO_IS_SYSTEM_INSTANCE;
    }

    private AccountOwnerConverter(boolean zeroIsSystem) {
        this.zeroIsSystem = zeroIsSystem;
    }

    public boolean isZeroIsSystem() {
        return this.zeroIsSystem;
    }

    @Override
    public String toString(AccountOwner object) {
        if (object instanceof Member) {
            return REFERENCE_CONVERTER.toString((Member)object);
        }
        return "";
    }

    @Override
    public AccountOwner valueOf(String string) {
        Member member = (Member)REFERENCE_CONVERTER.valueOf(string);
        return member == null ? (this.zeroIsSystem ? SystemAccountOwner.instance() : LoggedUser.accountOwner()) : member;
    }
}

