/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.ConversionException;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import org.apache.commons.lang.StringUtils;

public class AmountConverter
implements Converter<Amount> {
    private static final long serialVersionUID = -6090298605781552907L;
    private final DecimalFormat numberFormat;
    private final UnitsConverter unitsConverter;

    public AmountConverter(DecimalFormat numberFormat) {
        this(numberFormat, "#amount#");
    }

    public AmountConverter(DecimalFormat numberFormat, String unitsPattern) {
        this.numberFormat = numberFormat;
        this.unitsConverter = new UnitsConverter(unitsPattern, numberFormat);
    }

    @Override
    public String toString(Amount amount) {
        if (amount == null) {
            return null;
        }
        switch (amount.getType()) {
            case FIXED: {
                return this.unitsConverter.toString(amount.getValue());
            }
            case PERCENTAGE: {
                return this.numberFormat.format(amount.getValue()) + "%";
            }
        }
        return null;
    }

    @Override
    public Amount valueOf(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            Amount.Type type;
            BigDecimal amount;
            boolean percentage = string.endsWith("%");
            if (percentage) {
                amount = CoercionHelper.coerce(BigDecimal.class, this.numberFormat.parse(string.substring(0, string.length() - 1)));
                type = Amount.Type.PERCENTAGE;
            } else {
                amount = this.unitsConverter.valueOf(string.substring(0, string.length() - 1));
                type = Amount.Type.FIXED;
            }
            return new Amount(amount, type);
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid number: " + string);
        }
    }
}

