/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import nl.strohalm.cyclos.utils.conversion.ConversionException;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.lang.StringUtils;

public class CalendarConverter
implements Converter<Calendar> {
    private static final long serialVersionUID = 7608682322645824105L;
    private final DateFormat dateFormat;

    public CalendarConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.dateFormat.setLenient(false);
    }

    public CalendarConverter(String mask) {
        this(mask, null);
    }

    public CalendarConverter(String mask, TimeZone timeZone) {
        this(new SimpleDateFormat(mask));
        if (timeZone != null) {
            this.dateFormat.setTimeZone(timeZone);
        }
    }

    @Override
    public String toString(Calendar object) {
        if (object == null) {
            return null;
        }
        return this.dateFormat.format(object.getTime());
    }

    @Override
    public Calendar valueOf(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            Date date = this.dateFormat.parse(string);
            Calendar cal = Calendar.getInstance(this.dateFormat.getTimeZone());
            cal.setTime(date);
            return cal;
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid date: " + string);
        }
    }
}

