/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.math.BigInteger;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.lang.StringUtils;

public class CardNumberConverter
implements Converter<BigInteger> {
    private static final long serialVersionUID = 5645558428738888967L;
    private final String pattern;
    private static final String ALLOWED_BOUNDARY_CHARS = "#0123456789";

    public CardNumberConverter(String cardNumberPattern) {
        this.pattern = cardNumberPattern;
    }

    @Override
    public String toString(BigInteger number) {
        if (number == null) {
            return null;
        }
        int numbers = 0;
        for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            if (ALLOWED_BOUNDARY_CHARS.indexOf(c) < 0) continue;
            ++numbers;
        }
        String data = StringUtils.leftPad((String)number.toString(), (int)numbers, (char)'0');
        StringBuffer formatedCardNumber = new StringBuffer();
        int numberDigit = 0;
        for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            if (ALLOWED_BOUNDARY_CHARS.indexOf(c) >= 0) {
                formatedCardNumber.append(data.charAt(numberDigit));
                ++numberDigit;
                continue;
            }
            formatedCardNumber.append(c);
        }
        return formatedCardNumber.toString();
    }

    @Override
    public BigInteger valueOf(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return new BigInteger(StringHelper.onlyNumbers(string));
    }
}

