/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.IntValuedEnum;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.conversion.ConversionException;
import nl.strohalm.cyclos.utils.conversion.LocaleConverter;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ClassUtils;

public class CoercionHelper {
    public static <T> T coerce(Class<T> toType, Object value) {
        try {
            return (T)CoercionHelper.convert(toType, value);
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConversionException("Cannot convert " + value + " to " + toType.getName(), e);
        }
    }

    public static <T> Collection<T> coerceCollection(Class<T> elementType, Class<? extends Collection> collectionType, Object value) {
        Collection collection = ClassHelper.instantiate(collectionType == null ? ArrayList.class : collectionType);
        Iterator iterator = IteratorUtils.getIterator((Object)value);
        while (iterator.hasNext()) {
            collection.add(CoercionHelper.coerce(elementType, iterator.next()));
        }
        return collection;
    }

    public static <T> Collection<T> coerceCollection(Class<T> elementType, Object value) {
        return CoercionHelper.coerceCollection(elementType, null, value);
    }

    public static <T> T first(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    private static Object convert(Class toType, Object value) {
        if ("".equals(value)) {
            value = null;
        }
        if (value != null && !Collection.class.isAssignableFrom(toType) && !toType.isArray() && (value.getClass().isArray() || value instanceof Collection)) {
            Iterator it = IteratorUtils.getIterator((Object)value);
            value = !it.hasNext() ? null : it.next();
        }
        if (value == null) {
            if (toType.isPrimitive()) {
                value = toType == Boolean.TYPE ? Boolean.FALSE : (toType == Character.TYPE ? (Comparable<Character>)Character.valueOf('\u0000') : (Comparable<Character>)Integer.valueOf(0));
            } else {
                return null;
            }
        }
        if (toType.isInstance(value)) {
            return value;
        }
        if (toType.isPrimitive()) {
            toType = ClassUtils.primitiveToWrapper((Class)toType);
        }
        if (String.class.isAssignableFrom(toType)) {
            if (value instanceof Entity) {
                Long entityId = ((Entity)((Object)value)).getId();
                return entityId == null ? null : entityId.toString();
            }
            return value.toString();
        }
        if (Number.class.isAssignableFrom(toType)) {
            if (!(value instanceof Number)) {
                if (value instanceof String) {
                    value = new BigDecimal((String)((Object)value));
                } else if (value instanceof Date) {
                    value = ((Date)value).getTime();
                } else if (value instanceof Calendar) {
                    value = ((Calendar)value).getTimeInMillis();
                } else if (value instanceof Entity) {
                    if ((value = ((Entity)((Object)value)).getId()) == null) {
                        return null;
                    }
                } else {
                    throw new ConversionException("Invalid number: " + value);
                }
            }
            Number number = (Number)((Object)value);
            if (Byte.class.isAssignableFrom(toType)) {
                return number.byteValue();
            }
            if (Short.class.isAssignableFrom(toType)) {
                return number.shortValue();
            }
            if (Integer.class.isAssignableFrom(toType)) {
                return number.intValue();
            }
            if (Long.class.isAssignableFrom(toType)) {
                return number.longValue();
            }
            if (Float.class.isAssignableFrom(toType)) {
                return Float.valueOf(number.floatValue());
            }
            if (Double.class.isAssignableFrom(toType)) {
                return number.doubleValue();
            }
            if (BigInteger.class.isAssignableFrom(toType)) {
                return new BigInteger(number.toString());
            }
            if (BigDecimal.class.isAssignableFrom(toType)) {
                return new BigDecimal(number.toString());
            }
        } else {
            if (Boolean.class.isAssignableFrom(toType)) {
                if (value instanceof Number) {
                    return ((Number)((Object)value)).intValue() != 0;
                }
                if ("on".equalsIgnoreCase(value.toString())) {
                    return true;
                }
                return Boolean.parseBoolean(value.toString());
            }
            if (Character.class.isAssignableFrom(toType)) {
                String str = value.toString();
                return str.length() == 0 ? null : Character.valueOf(str.charAt(0));
            }
            if (Calendar.class.isAssignableFrom(toType)) {
                if (value instanceof Date) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime((Date)value);
                    return cal;
                }
            } else if (Date.class.isAssignableFrom(toType)) {
                if (value instanceof Calendar) {
                    long millis = ((Calendar)value).getTimeInMillis();
                    try {
                        return ConstructorUtils.invokeConstructor((Class)toType, (Object)millis);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            } else {
                Collection<?> collection;
                if (Enum.class.isAssignableFrom(toType)) {
                    Object ret;
                    try {
                        ret = Enum.valueOf(toType, value.toString());
                    }
                    catch (Exception e) {
                        ret = null;
                    }
                    if (ret == null) {
                        Object[] possible;
                        try {
                            possible = (Object[])toType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Couldn't invoke the 'values' method for enum " + toType.getName());
                        }
                        if (StringValuedEnum.class.isAssignableFrom(toType)) {
                            String test = CoercionHelper.coerce(String.class, value);
                            for (Object item : possible) {
                                if (!((StringValuedEnum)item).getValue().equals(test)) continue;
                                ret = item;
                                break;
                            }
                        } else if (IntValuedEnum.class.isAssignableFrom(toType)) {
                            int test = CoercionHelper.coerce(Integer.TYPE, value);
                            for (Object item : possible) {
                                if (((IntValuedEnum)item).getValue() != test) continue;
                                ret = item;
                                break;
                            }
                        } else {
                            throw new ConversionException("Invalid enum: " + value);
                        }
                    }
                    return ret;
                }
                if (Entity.class.isAssignableFrom(toType)) {
                    Long id = CoercionHelper.coerce(Long.class, value);
                    return EntityHelper.reference(toType, id);
                }
                if (Locale.class.isAssignableFrom(toType)) {
                    return LocaleConverter.instance().valueOf(value.toString());
                }
                if (Collection.class.isAssignableFrom(toType)) {
                    collection = (Collection<?>)ClassHelper.instantiate(toType);
                    Iterator iterator = IteratorUtils.getIterator((Object)value);
                    while (iterator.hasNext()) {
                        collection.add(iterator.next());
                    }
                    return collection;
                }
                if (toType.isArray()) {
                    collection = CoercionHelper.coerceCollection(toType.getComponentType(), value);
                    Object[] array = (Object[])Array.newInstance(toType.getComponentType(), collection.size());
                    return collection.toArray(array);
                }
            }
        }
        throw new ConversionException("Cannot coerce value to: " + toType.getName());
    }
}

