/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.util.Collection;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.utils.ElementVO;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.conversion.FormatOnlyConverter;
import org.apache.commons.lang.StringUtils;

public class CustomFieldConverter
extends FormatOnlyConverter<Collection<? extends CustomFieldValue>> {
    private static final long serialVersionUID = -2712015051659215620L;
    private final CustomField customField;
    private final LocalSettings localSettings;
    private final ElementService elementService;

    public CustomFieldConverter(CustomField customField, ElementService elementService, LocalSettings localSettings) {
        this.customField = customField;
        this.elementService = elementService;
        this.localSettings = localSettings;
    }

    @Override
    public String toString(Collection<? extends CustomFieldValue> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        CustomFieldValue value = null;
        for (CustomFieldValue customFieldValue : values) {
            if (!this.customField.equals(customFieldValue.getField())) continue;
            value = customFieldValue;
            break;
        }
        String fieldValue = null;
        if (value != null) {
            if (this.customField.getType() == CustomField.Type.ENUMERATED) {
                if (value.getPossibleValue() != null) {
                    fieldValue = value.getPossibleValue().getValue();
                } else {
                    Collection<CustomFieldPossibleValue> collection = this.customField.getPossibleValues(false);
                    for (CustomFieldPossibleValue possibleValue : collection) {
                        if (!String.valueOf(possibleValue.getId()).equals(value.getValue())) continue;
                        fieldValue = possibleValue.getValue();
                        break;
                    }
                }
            } else if (this.customField.getType() == CustomField.Type.MEMBER) {
                Member member = value.getMemberValue();
                ElementVO vo = null;
                if (member != null) {
                    try {
                        vo = this.elementService.getElementVO(member.getId());
                    }
                    catch (Exception e) {
                        vo = null;
                    }
                }
                if (vo != null) {
                    fieldValue = this.localSettings.getMemberResultDisplay() == LocalSettings.MemberResultDisplay.NAME ? vo.getName() : vo.getUsername();
                }
            } else {
                fieldValue = value.getValue();
                if (StringUtils.isNotEmpty((String)this.customField.getPattern())) {
                    fieldValue = StringHelper.applyMask(this.customField.getPattern(), fieldValue);
                }
            }
        }
        return fieldValue;
    }
}

