/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.ConversionException;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.lang.StringUtils;

public class FixedLengthNumberConverter<T extends Number>
implements Converter<T> {
    private static final int DEFAULT_PRECISION = 15;
    private static final long serialVersionUID = 2163122907372592999L;
    private Class<T> numberType;
    private int precision = 15;
    private int scale;
    private BigDecimal divisor;

    public FixedLengthNumberConverter(Class<T> numberType, int scale) {
        this.numberType = numberType;
        this.scale = scale;
        this.divisor = BigDecimal.TEN.pow(scale);
    }

    public FixedLengthNumberConverter(Class<T> numberType, int precision, int scale) {
        this(numberType, scale);
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String toString(T object) {
        BigDecimal number = CoercionHelper.coerce(BigDecimal.class, object);
        if (number == null) {
            return null;
        }
        return StringUtils.leftPad((String)number.unscaledValue().toString(), (int)this.precision, (char)'0');
    }

    @Override
    public T valueOf(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (!StringUtils.isNumeric((String)string)) {
            throw new ConversionException("Invalid string. Expecting only numbers, but received " + string);
        }
        BigDecimal number = new BigDecimal(new BigInteger(string)).divide(this.divisor, this.scale, RoundingMode.HALF_UP);
        return (T)((Number)CoercionHelper.coerce(this.numberType, number));
    }
}

