/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.io.Reader;
import java.io.StringReader;
import nl.strohalm.cyclos.utils.XmlHelper;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class HtmlConverter
implements Converter<String> {
    private static final long serialVersionUID = -1184040713929519035L;
    private static final String[] BAD_TAGS = new String[]{"script", "style", "iframe", "form"};
    private static final HtmlConverter INSTANCE = new HtmlConverter(true);
    private static HtmlConverter INSTANCE_NBSP = null;
    private static final int NBSP = 160;
    private boolean removeBlankspaces;

    public static HtmlConverter instance() {
        return HtmlConverter.instance(true);
    }

    public static HtmlConverter instance(boolean removeBlankspaces) {
        if (removeBlankspaces) {
            return INSTANCE;
        }
        if (INSTANCE_NBSP == null) {
            INSTANCE_NBSP = new HtmlConverter(false);
        }
        return INSTANCE_NBSP;
    }

    private static void removeBadNodes(Document document) {
        NodeList elements = document.getElementsByTagName("*");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            if (ArrayUtils.contains((Object[])BAD_TAGS, (Object)element.getTagName())) {
                element.getParentNode().removeChild(element);
            }
            NamedNodeMap attributes = element.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Attr attr = (Attr)attributes.item(j);
                if (!attr.getNodeName().startsWith("on")) continue;
                element.removeAttributeNode(attr);
            }
        }
    }

    private HtmlConverter(boolean removeBlankspaces) {
        this.removeBlankspaces = removeBlankspaces;
    }

    @Override
    public String toString(String string) {
        return string;
    }

    @Override
    public String valueOf(String string) {
        if (StringUtils.isBlank((String)string)) {
            return this.removeBlankspaces ? null : string;
        }
        Tidy tidy = new Tidy();
        tidy.setXHTML(false);
        tidy.setQuiet(true);
        tidy.setShowErrors(0);
        tidy.setShowWarnings(false);
        tidy.setIndentContent(false);
        tidy.setXmlOut(true);
        Document document = tidy.parseDOM((Reader)new StringReader(string), null);
        HtmlConverter.removeBadNodes(document);
        NodeList bodies = document.getElementsByTagName("body");
        if (bodies.getLength() == 0) {
            return null;
        }
        String result = XmlHelper.toString(bodies.item(0));
        result = result.substring(result.indexOf("<body>") + "<body>".length(), result.indexOf("</body>"));
        if (this.removeBlankspaces) {
            int begin = 0;
            while (result.charAt(begin) == '\u00a0') {
                if (++begin != result.length()) continue;
                return null;
            }
            int end = result.length();
            while (result.charAt(end - 1) == '\u00a0') {
                --end;
            }
            return StringUtils.trimToNull((String)result.substring(begin, end));
        }
        return StringUtils.trimToNull((String)result);
    }
}

