/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.util.Locale;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.lang.StringUtils;

public class LocaleConverter
implements Converter<Locale> {
    private static final long serialVersionUID = -6076434697689630259L;
    private static final LocaleConverter INSTANCE = new LocaleConverter();

    public static LocaleConverter instance() {
        return INSTANCE;
    }

    @Override
    public String toString(Locale locale) {
        if (locale == null) {
            return null;
        }
        String variant = locale.getVariant();
        if (StringUtils.isEmpty((String)variant)) {
            return locale.getLanguage() + "_" + locale.getCountry();
        }
        return locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
    }

    @Override
    public Locale valueOf(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        String[] parts = StringUtils.split((String)string, (String)"_");
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }
}

