/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.lang.StringUtils;

public class NumberConverter<T extends Number>
implements Converter<T>,
Cloneable {
    private static final long serialVersionUID = -473661346133459797L;
    private final DecimalFormat numberFormat;
    private final Class<T> numberType;
    private boolean negativeToAbsoluteValue;
    private volatile BigDecimal delta;

    public NumberConverter(Class<T> numberType, DecimalFormat numberFormat) {
        this.numberType = numberType;
        this.numberFormat = numberFormat;
    }

    public DecimalFormat getNumberFormat() {
        return this.numberFormat;
    }

    public Class<T> getNumberType() {
        return this.numberType;
    }

    public NumberConverter<T> negativeToAbsolute() {
        try {
            NumberConverter clone = (NumberConverter)this.clone();
            clone.negativeToAbsoluteValue = true;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String toString(T number) {
        if (number == null) {
            return null;
        }
        BigDecimal bigDecimal = CoercionHelper.coerce(BigDecimal.class, number);
        if (this.negativeToAbsoluteValue) {
            bigDecimal = bigDecimal.abs();
        }
        BigDecimal delta = this.getDelta();
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0 && bigDecimal.compareTo(delta) > 0) {
            bigDecimal = BigDecimal.ZERO;
        }
        return this.numberFormat.format(bigDecimal);
    }

    @Override
    public T valueOf(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        DecimalFormatSymbols symbols = this.numberFormat.getDecimalFormatSymbols();
        char minusSign = symbols.getMinusSign();
        char decimalSeparator = symbols.getDecimalSeparator();
        char groupingSeparator = symbols.getGroupingSeparator();
        boolean negativeNumber = false;
        if (string.indexOf(minusSign) > -1) {
            string = StringUtils.replace((String)string, (String)String.valueOf(minusSign), (String)"");
            negativeNumber = true;
        }
        String[] parts = StringUtils.split((String)string, (String)String.valueOf(decimalSeparator));
        String integerPart = StringUtils.replace((String)parts[0], (String)String.valueOf(groupingSeparator), (String)"");
        boolean hasDecimalPart = parts.length > 1;
        String decimalPart = hasDecimalPart ? parts[1] : "";
        String bigDecimalString = integerPart;
        if (hasDecimalPart) {
            bigDecimalString = bigDecimalString + "." + decimalPart;
        }
        if (negativeNumber) {
            bigDecimalString = "-" + bigDecimalString;
        }
        BigDecimal bigDecimal = new BigDecimal(bigDecimalString);
        Number value = (Number)CoercionHelper.coerce(this.numberType, bigDecimal);
        if (this.negativeToAbsoluteValue && value != null && value.floatValue() < 0.0f) {
            value = (Number)CoercionHelper.coerce(this.numberType, Float.valueOf(-value.floatValue()));
        }
        return (T)value;
    }

    private BigDecimal getDelta() {
        if (this.delta == null) {
            int precision = this.numberFormat.getMaximumFractionDigits();
            this.delta = BigDecimal.ONE.divide(BigDecimal.TEN.pow(precision), precision, RoundingMode.HALF_UP).negate();
        }
        return this.delta;
    }
}

