/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.util.Set;
import nl.strohalm.cyclos.utils.conversion.ConversionException;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.lang.StringUtils;

public class SetConverter<T extends Set<?>>
implements Converter<T> {
    private static final long serialVersionUID = 7393904915691049648L;
    private String separator;
    private Class<T> clazz;

    public SetConverter(Class<T> clazz, String separator) {
        this.separator = separator;
        this.clazz = clazz;
    }

    @Override
    public String toString(T object) {
        return StringUtils.join(object, (String)this.separator);
    }

    @Override
    public T valueOf(String string) {
        Set rs;
        String[] split = string.split(this.separator);
        try {
            rs = (Set)this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new ConversionException("Error converting from String to Set: " + e.getMessage(), e);
        }
        for (String s : split) {
            rs.add(s.trim());
        }
        return (T)rs;
    }
}

