/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.lang.StringUtils;

public class StringTrimmerConverter
implements Converter<String> {
    public static String DEFAULT_TRIM = " \t\n\r";
    public static String PRESERVE_BLANKS_TRIM = "\t\n\r";
    private static final long serialVersionUID = 2683361873400418066L;
    private static final StringTrimmerConverter INSTANCE = new StringTrimmerConverter();
    private final String trimBoth;
    private final String trimLeft;
    private final String trimRight;

    public static StringTrimmerConverter instance() {
        return INSTANCE;
    }

    public static StringTrimmerConverter instance(String trimBoth) {
        return new StringTrimmerConverter(trimBoth, null, null);
    }

    public StringTrimmerConverter() {
        this(null, null, null);
    }

    public StringTrimmerConverter(String trimBoth) {
        this(trimBoth, null, null);
    }

    public StringTrimmerConverter(String trimBoth, String trimLeft, String trimRight) {
        this.trimBoth = trimBoth == null ? DEFAULT_TRIM : trimBoth;
        this.trimLeft = trimLeft == null ? "" : trimLeft;
        this.trimRight = trimRight == null ? "" : trimRight;
    }

    public String getTrimBoth() {
        return this.trimBoth;
    }

    public String getTrimLeft() {
        return this.trimLeft;
    }

    public String getTrimRight() {
        return this.trimRight;
    }

    @Override
    public String toString(String object) {
        return object;
    }

    @Override
    public String valueOf(String string) {
        String rightChars;
        int start;
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        string = StringHelper.removeMarkupTags(string);
        int end = string.length() - 1;
        String leftChars = this.trimBoth + this.trimLeft;
        if (leftChars.length() > 0) {
            for (start = 0; start < string.length() && leftChars.indexOf(string.charAt(start)) >= 0; ++start) {
            }
        }
        if ((rightChars = this.trimBoth + this.trimRight).length() > 0) {
            while (end > 0 && rightChars.indexOf(string.charAt(end)) >= 0) {
                --end;
            }
        }
        if (start > end) {
            return null;
        }
        String result = string.substring(start, end + 1);
        return result.length() == 0 ? null : result;
    }
}

