/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.conversion;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import org.apache.commons.lang.StringUtils;

public class UnitsConverter
extends NumberConverter<BigDecimal> {
    private static final long serialVersionUID = -7257124464780039240L;
    private final String pattern;
    private final char decimalSeparator;
    private final char groupingSeparator;

    public UnitsConverter(String pattern, DecimalFormat numberFormat) {
        super(BigDecimal.class, numberFormat);
        this.pattern = StringUtils.replace((String)pattern, (String)"#amount#", (String)"{0}");
        DecimalFormatSymbols symbols = numberFormat.getDecimalFormatSymbols();
        this.decimalSeparator = symbols.getDecimalSeparator();
        this.groupingSeparator = symbols.getGroupingSeparator();
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String toString(BigDecimal object) {
        String number = super.toString(object);
        if (number == null) {
            return null;
        }
        return MessageFormat.format(this.pattern, number);
    }

    @Override
    public BigDecimal valueOf(String string) {
        int begin;
        if (string == null) {
            return null;
        }
        int end = string.length() - 1;
        for (begin = 0; !this.isValidChar(string.charAt(begin)) && begin < string.length(); ++begin) {
        }
        while (!this.isValidChar(string.charAt(end)) && end > 0) {
            --end;
        }
        return (BigDecimal)super.valueOf(string.substring(begin, end + 1));
    }

    private boolean isValidChar(char c) {
        return Character.isDigit(c) || c == this.decimalSeparator || c == this.groupingSeparator;
    }
}

