/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.csv;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import nl.strohalm.cyclos.utils.conversion.Converter;

public abstract class BaseCSVHandler<E> {
    protected List<Column> columns = new LinkedList<Column>();
    protected final Class<E> elementClass;
    protected char stringQuote = (char)34;
    protected char valueSeparator = (char)44;

    protected BaseCSVHandler(Class<E> elementClass) {
        this.elementClass = elementClass;
    }

    public void addColumn(String header, String property) {
        this.addColumn(header, property, null);
    }

    public void addColumn(String header, String property, Converter<?> converter) {
        this.columns.add(new Column(header, property, converter));
    }

    public Class<E> getElementClass() {
        return this.elementClass;
    }

    public char getStringQuote() {
        return this.stringQuote;
    }

    public char getValueSeparator() {
        return this.valueSeparator;
    }

    public void setStringQuote(char stringQuote) {
        this.stringQuote = stringQuote;
    }

    public void setValueSeparator(char valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    protected static class Column
    implements Serializable {
        private static final long serialVersionUID = 2620085284405140210L;
        private final String header;
        private final String property;
        private final Converter<?> converter;

        public Column(String header, String property, Converter<?> converter) {
            this.header = header;
            this.property = property;
            this.converter = converter;
        }

        public Converter<?> getConverter() {
            return this.converter;
        }

        public String getHeader() {
            return this.header;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

