/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.csv.BaseCSVHandler;
import nl.strohalm.cyclos.utils.csv.CSVParseException;
import org.apache.commons.beanutils.PropertyUtils;

public class CSVReader<E>
extends BaseCSVHandler<E> {
    private int headerLines;

    public static <E> CSVReader<E> instance(Class<E> elementClass, LocalSettings localSettings) {
        CSVReader<E> reader = new CSVReader<E>(elementClass);
        reader.setValueSeparator(CoercionHelper.coerce(Character.TYPE, localSettings.getCsvValueSeparator().getValue()).charValue());
        reader.setStringQuote(CoercionHelper.coerce(Character.TYPE, localSettings.getCsvStringQuote().getValue()).charValue());
        return reader;
    }

    public static List<String> readLine(Reader reader, char stringQuote, char valueSeparator) throws IOException {
        int read;
        ArrayList<String> values = new ArrayList<String>();
        boolean inQuotes = false;
        boolean previousWasQuote = false;
        StringBuilder value = new StringBuilder();
        while ((read = reader.read()) > 0) {
            char c = (char)read;
            if (c == stringQuote) {
                if (previousWasQuote) {
                    value.append(stringQuote);
                    previousWasQuote = false;
                } else {
                    previousWasQuote = true;
                }
                inQuotes = !inQuotes;
                continue;
            }
            previousWasQuote = false;
            if (c == valueSeparator) {
                if (inQuotes) {
                    value.append(c);
                    continue;
                }
                values.add(value.toString().trim());
                value.setLength(0);
                continue;
            }
            if (c == '\r' || c == '\n') {
                if (inQuotes) {
                    value.append('\n');
                    continue;
                }
                if (value.length() == 0 && values.isEmpty()) {
                    return Collections.emptyList();
                }
                values.add(value.toString().trim());
                return values;
            }
            value.append(c);
        }
        if (value.length() > 0) {
            values.add(value.toString().trim());
        }
        return values.isEmpty() ? null : values;
    }

    public CSVReader(Class<E> elementClass) {
        super(elementClass);
    }

    public int getHeaderLines() {
        return this.headerLines;
    }

    public List<E> read(BufferedReader in) throws CSVParseException {
        int linesIndex = 0;
        LinkedList list = new LinkedList();
        try {
            List<String> values;
            while ((values = this.readLine(in)) != null) {
                if (this.headerLines >= ++linesIndex) continue;
                Object object = this.elementClass.newInstance();
                int size = Math.min(this.columns.size(), values.size());
                for (int i = 0; i < size; ++i) {
                    BaseCSVHandler.Column column = (BaseCSVHandler.Column)this.columns.get(i);
                    String property = column.getProperty();
                    if (property == null) continue;
                    Class type = PropertyUtils.getPropertyType(object, (String)property);
                    String stringValue = values.get(i);
                    Object objectValue = PropertyHelper.getAsObject(type, stringValue, column.getConverter());
                    PropertyHelper.set(object, property, objectValue);
                }
                list.add(object);
            }
            return list;
        }
        catch (Exception e) {
            throw new CSVParseException(linesIndex);
        }
    }

    public List<String> readLine(Reader reader) throws IOException {
        return CSVReader.readLine(reader, this.stringQuote, this.valueSeparator);
    }

    public void setHeaderLines(int headerLines) {
        this.headerLines = headerLines;
    }
}

