/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.csv;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.csv.BaseCSVHandler;
import org.apache.commons.lang.StringUtils;

public class CSVWriter<E>
extends BaseCSVHandler<E> {
    protected String rowSeparator;
    private boolean useHeader;

    public static <E> CSVWriter<E> instance(Class<E> elementClass, LocalSettings localSettings) {
        CSVWriter<E> writer = new CSVWriter<E>(elementClass);
        writer.setValueSeparator(CoercionHelper.coerce(Character.TYPE, localSettings.getCsvValueSeparator().getValue()).charValue());
        writer.setStringQuote(CoercionHelper.coerce(Character.TYPE, localSettings.getCsvStringQuote().getValue()).charValue());
        writer.setRowSeparator(localSettings.getCsvRecordSeparator().getValue());
        writer.setUseHeader(localSettings.isCsvUseHeader());
        return writer;
    }

    public CSVWriter(Class<E> elementClass) {
        super(elementClass);
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public boolean isUseHeader() {
        return this.useHeader;
    }

    public void setRowSeparator(String rowSeparator) {
        this.rowSeparator = rowSeparator;
    }

    public void setUseHeader(boolean useHeader) {
        this.useHeader = useHeader;
    }

    public void write(List<E> results, PrintWriter out) {
        this.writeHeader(out);
        for (E element : results) {
            this.writeRow(element, out);
        }
    }

    public void writeHeader(PrintWriter out) {
        if (this.useHeader) {
            ArrayList<String> row = new ArrayList<String>();
            for (BaseCSVHandler.Column column : this.columns) {
                row.add(this.stringQuote + column.getHeader() + this.stringQuote);
            }
            out.print(StringUtils.join(row.iterator(), (char)this.valueSeparator) + this.rowSeparator);
        }
    }

    public void writeRow(E element, PrintWriter out) {
        ArrayList<String> row = new ArrayList<String>();
        for (BaseCSVHandler.Column column : this.columns) {
            Object objectValue = PropertyHelper.get(element, column.getProperty());
            String stringValue = PropertyHelper.getAsString(objectValue, column.getConverter());
            row.add(this.escape(stringValue, this.stringQuote));
        }
        out.print(StringUtils.join(row.iterator(), (char)this.valueSeparator) + this.rowSeparator);
    }

    private String escape(String value, char stringQuote) {
        String string = StringUtils.trimToEmpty((String)value);
        char[] chars = string.toCharArray();
        int length = chars.length;
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (c == stringQuote) {
                sb.append(stringQuote).append(stringQuote);
                continue;
            }
            sb.append(c);
        }
        return stringQuote + sb.toString() + stringQuote;
    }
}

