/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.customizedfile;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.utils.customizedfile.CustomizedFileHandler;
import nl.strohalm.cyclos.utils.customizedfile.ImageChangeListener;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ServletContextAware;

public abstract class BaseCustomizedFileHandler
implements ServletContextAware,
CustomizedFileHandler {
    protected static final Log LOG = LogFactory.getLog(BaseCustomizedFileHandler.class);
    private ServletContext context;
    private List<ImageChangeListener> imageChangeListeners = new ArrayList<ImageChangeListener>();

    @Override
    public void addImageChangeListener(ImageChangeListener listener) {
        this.imageChangeListeners.add(listener);
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    protected final synchronized void deleteLocally(String path) {
        String realPath = this.context.getRealPath(path);
        File file = new File(realPath);
        file.delete();
        LOG.debug((Object)("Deleted file " + file));
        File dir = file.getParentFile();
        if (ArrayUtils.isEmpty((Object[])dir.listFiles())) {
            LOG.debug((Object)("Deleted empty dir " + dir));
            dir.delete();
        }
    }

    protected void notifyImageChangeListenersLocally(Image image) {
        for (ImageChangeListener listener : this.imageChangeListeners) {
            listener.onImageChanged(image);
        }
    }

    protected final synchronized void writeLocally(String path, long lastModified, byte[] contents) {
        String realPath = this.context.getRealPath(path);
        File file = new File(realPath);
        file.getParentFile().mkdirs();
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(contents, 0, contents.length);
            file.setLastModified(lastModified);
            LOG.debug((Object)("Wrote local file " + file));
        }
        catch (Exception e) {
            LOG.error((Object)"Error writing local file", (Throwable)e);
        }
    }
}

