/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.customizedfile;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.utils.HazelcastHelper;
import nl.strohalm.cyclos.utils.customizedfile.BaseCustomizedFileHandler;
import nl.strohalm.cyclos.utils.customizedfile.CustomizedFileOperation;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HazelcastCustomizedFileHandler
extends BaseCustomizedFileHandler
implements ApplicationContextAware {
    private ITopic<CustomizedFileOperation> customizedFilesTopic;
    private ITopic<Image> imageChangesTopic;

    @Override
    public synchronized void delete(String path) {
        this.publish(CustomizedFileOperation.forDelete(path));
    }

    @Override
    public void notifyImageChangeListeners(Image image) {
        this.imageChangesTopic.publish((Object)image);
    }

    public void onCustomizedFileMessage(CustomizedFileOperation operation) {
        LOG.debug((Object)("Executing received customized file event: " + (Object)((Object)operation.getType())));
        switch (operation.getType()) {
            case DELETE: {
                this.deleteLocally(operation.getPath());
                break;
            }
            case WRITE: {
                this.writeLocally(operation.getPath(), operation.getLastModified(), operation.getContents());
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        HazelcastInstance hazelcastInstance = HazelcastHelper.getHazelcastInstance(applicationContext);
        this.customizedFilesTopic = hazelcastInstance.getTopic("cyclos.CustomizedFiles");
        this.customizedFilesTopic.addMessageListener((MessageListener)new MessageListener<CustomizedFileOperation>(){

            public void onMessage(Message<CustomizedFileOperation> message) {
                HazelcastCustomizedFileHandler.this.onCustomizedFileMessage((CustomizedFileOperation)message.getMessageObject());
            }
        });
        this.imageChangesTopic = hazelcastInstance.getTopic("cyclos.ImageChanges");
        this.imageChangesTopic.addMessageListener((MessageListener)new MessageListener<Image>(){

            public void onMessage(Message<Image> message) {
                HazelcastCustomizedFileHandler.this.onImageMessage((Image)message.getMessageObject());
            }
        });
    }

    @Override
    public synchronized void write(String path, long lastModified, byte[] contents) {
        this.publish(CustomizedFileOperation.forWrite(path, lastModified, contents));
    }

    private void onImageMessage(Image image) {
        this.notifyImageChangeListenersLocally(image);
    }

    private void publish(CustomizedFileOperation operation) {
        LOG.debug((Object)("Publishing customized file event: " + operation));
        this.customizedFilesTopic.publish((Object)operation);
    }
}

