/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.guarantees;

import java.math.BigDecimal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeVO;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;

public class GuaranteesHelper {
    public static BigDecimal calculateFee(Period period, BigDecimal amount, GuaranteeFeeVO guaranteeFee) {
        Amount result = null;
        switch (guaranteeFee.getType()) {
            case FIXED: {
                result = Amount.fixed(guaranteeFee.getFee());
            }
            case PERCENTAGE: {
                result = result != null ? result : Amount.percentage(guaranteeFee.getFee());
                return result.apply(amount);
            }
            case VARIABLE_ACCORDING_TO_TIME: {
                if (period.getBegin().after(period.getEnd())) {
                    throw new IllegalArgumentException("Can't calculate the guarantee fee. Invalid period time: the begin date must be less than the end date");
                }
                if (amount.doubleValue() == 0.0 || guaranteeFee.getFee().doubleValue() == 0.0) {
                    return BigDecimal.ZERO;
                }
                double periodInDays = DateHelper.daysBetween(period.getBegin(), period.getEnd());
                double pow = periodInDays / 365.0;
                double value = (Math.pow(1.0 + guaranteeFee.getFee().doubleValue() / 100.0, pow) - 1.0) * amount.doubleValue();
                return new BigDecimal(value);
            }
        }
        throw new IllegalArgumentException("Can't calculate the guarantee fee: unknown fee type: " + guaranteeFee.getType());
    }
}

