/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public abstract class AbstractEnumType<EnumType>
implements UserType,
ParameterizedType,
Serializable {
    private static final long serialVersionUID = 5977505341208670187L;
    private Class<EnumType> enumType;
    private EnumType[] enumValues;

    protected static <E extends AbstractEnumType<?>, T extends Enum<?>> Type getType(Class<E> enumType, Class<T> enumClass) {
        Properties properties = new Properties();
        properties.setProperty("enumClassName", enumClass.getName());
        return new TypeFactory().custom(enumType, properties);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtils.equals((Object)x, (Object)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x == null ? -1 : x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class<?> returnedClass() {
        return this.enumType;
    }

    public void setParameterValues(Properties params) {
        Class<?> clazz;
        String enumClassName = params.getProperty("enumClassName");
        if (enumClassName == null) {
            throw new MappingException("enumClassName parameter not specified");
        }
        try {
            clazz = Class.forName(enumClassName);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("enumClass " + enumClassName + " not found", (Throwable)e);
        }
        if (!Enum.class.isAssignableFrom(clazz)) {
            throw new MappingException("enumClass " + enumClassName + " is not an enumeration");
        }
        this.enumType = clazz;
        try {
            Method values = this.enumType.getMethod("values", new Class[0]);
            this.enumValues = (Object[])values.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new MappingException("enumClass " + enumClassName + " does not have the values() method");
        }
    }

    protected Class<EnumType> getEnumType() {
        return this.enumType;
    }

    protected EnumType[] getEnumValues() {
        return this.enumValues;
    }
}

