/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.utils.Amount;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class AmountType
implements UserType,
Serializable {
    private static final long serialVersionUID = 5484455100860932944L;
    private static final Log LOG = LogFactory.getLog(AmountType.class);

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value == null ? null : ((Amount)value).clone();
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object arg0, Object arg1) throws HibernateException {
        return ObjectUtils.equals((Object)arg0, (Object)arg1);
    }

    public int hashCode(Object arg0) throws HibernateException {
        return arg0.hashCode();
    }

    public boolean isMutable() {
        return true;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Amount amount = new Amount();
        BigDecimal value = rs.getBigDecimal(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        amount.setValue(value);
        String type = rs.getString(names[1]);
        if (type == null) {
            return null;
        }
        amount.setType(Amount.Type.getFromValue(type));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning " + value + " as column " + names[0]));
            LOG.debug((Object)("Returning " + type + " as column " + names[1]));
        }
        return amount;
    }

    public void nullSafeSet(PreparedStatement ps, Object object, int index) throws HibernateException, SQLException {
        Amount amount = (Amount)object;
        BigDecimal value = null;
        Amount.Type type = null;
        if (amount != null) {
            value = amount.getValue();
            type = amount.getType();
        }
        if (value == null) {
            ps.setNull(index, 2);
        } else {
            ps.setBigDecimal(index, value);
        }
        if (type == null) {
            ps.setNull(index + 1, 1);
        } else {
            ps.setString(index + 1, type.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Binding " + value + " to parameter: " + index));
            LOG.debug((Object)("Binding " + (type == null ? null : type.getValue()) + " to parameter: " + (index + 1)));
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Class<?> returnedClass() {
        return Amount.class;
    }

    public int[] sqlTypes() {
        int[] columns = new int[]{2, 1};
        return columns;
    }
}

