/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import nl.strohalm.cyclos.utils.Period;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

public abstract class BasePeriodType
implements CompositeUserType,
Serializable {
    private static final long serialVersionUID = 7090490642092717202L;
    private static final int BEGIN = 0;
    private static final int END = 1;
    private static final String[] NAMES = new String[]{"begin", "end"};

    public Object assemble(Serializable value, SessionImplementor session, Object owner) throws HibernateException {
        return value == null ? null : ((Period)value).clone();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value == null ? null : ((Period)value).clone();
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return value == null ? null : ((Period)value).clone();
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtils.equals((Object)x, (Object)y);
    }

    public String[] getPropertyNames() {
        return NAMES;
    }

    public abstract Type[] getPropertyTypes();

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        Period period = (Period)component;
        switch (property) {
            case 0: {
                return period.getBegin();
            }
            case 1: {
                return period.getEnd();
            }
        }
        return null;
    }

    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public boolean isMutable() {
        return true;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Calendar cal;
        Timestamp begin = rs.getTimestamp(names[0]);
        Timestamp end = rs.getTimestamp(names[1]);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("Returning " + begin + " as column " + names[0]));
            this.getLog().debug((Object)("Returning " + end + " as column " + names[1]));
        }
        if (begin == null && end == null) {
            return null;
        }
        Period period = new Period();
        if (begin == null) {
            period.setBegin(null);
        } else {
            cal = Calendar.getInstance();
            cal.setTime(begin);
            period.setBegin(cal);
        }
        if (end == null) {
            period.setEnd(null);
        } else {
            cal = Calendar.getInstance();
            cal.setTime(end);
            period.setEnd(cal);
        }
        return period;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        Period period = (Period)value;
        Timestamp begin = null;
        Timestamp end = null;
        if (period != null && period.getBegin() != null) {
            begin = new Timestamp(period.getBegin().getTimeInMillis());
        }
        if (period != null && period.getEnd() != null) {
            end = new Timestamp(period.getEnd().getTimeInMillis());
        }
        st.setTimestamp(index + 0, begin);
        st.setTimestamp(index + 1, end);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("Binding " + begin + " to parameter: " + (index + 0)));
            this.getLog().debug((Object)("Binding " + end + " to parameter: " + (index + 1)));
        }
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        return original == null ? null : ((Period)original).clone();
    }

    public Class<?> returnedClass() {
        return Period.class;
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        Period period = (Period)component;
        switch (property) {
            case 0: {
                period.setBegin((Calendar)value);
                break;
            }
            case 1: {
                period.setEnd((Calendar)value);
            }
        }
    }

    protected abstract Log getLog();
}

