/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.dao.customizations.CustomFieldPossibleValueDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.commons.lang.StringUtils;

public class HibernateCustomFieldHandler {
    private FetchDAO fetchDao;
    private CustomFieldPossibleValueDAO customFieldPossibleValueDao;

    public void appendConditions(StringBuilder hql, Map<String, Object> namedParameters, Collection<? extends CustomFieldValue> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        block8: for (CustomFieldValue customFieldValue : values) {
            CustomField field = customFieldValue.getField();
            if (field == null) continue;
            field = this.fetchDao.fetch(field, new Relationship[0]);
            String value = customFieldValue.getValue();
            if ((value = StringUtils.trimToNull((String)StringUtils.replace((String)value, (String)"%", (String)""))) == null) continue;
            String alias = this.alias(field);
            String fieldParam = "field_" + alias;
            String valueParam = "value_" + alias;
            hql.append(" and ").append(alias).append(".field = :").append(fieldParam);
            namedParameters.put(fieldParam, field);
            if (LoggedUser.hasUser() && !LoggedUser.isAdministrator() && field.getNature() == CustomField.Nature.MEMBER) {
                hql.append(" and ").append(alias).append(".hidden <> true");
            }
            switch (field.getType()) {
                case STRING: {
                    if (StringUtils.isNotEmpty((String)field.getPattern())) {
                        value = StringHelper.removeMask(field.getPattern(), value, false);
                        hql.append(" and ").append(alias).append(".stringValue like :").append(valueParam);
                        namedParameters.put(valueParam, value);
                        continue block8;
                    }
                    hql.append(" and ").append(alias).append(".stringValue like :").append(valueParam);
                    namedParameters.put(valueParam, StringUtils.trimToEmpty((String)value) + "%");
                    continue block8;
                }
                case BOOLEAN: {
                    if (Boolean.parseBoolean(value)) {
                        hql.append(" and ").append(alias).append(".stringValue = :" + valueParam);
                    } else {
                        hql.append(" and ").append(alias).append(".stringValue <> :" + valueParam);
                    }
                    namedParameters.put(valueParam, "true");
                    continue block8;
                }
                case ENUMERATED: {
                    boolean byName = true;
                    if (StringUtils.containsOnly((String)value, (String)"0123456789,")) {
                        try {
                            String[] possibleValueIds;
                            ArrayList<CustomFieldPossibleValue> possibleValues = new ArrayList<CustomFieldPossibleValue>();
                            for (String idAsString : possibleValueIds = StringUtils.split((String)value, (char)',')) {
                                CustomFieldPossibleValue possibleValue = (CustomFieldPossibleValue)this.customFieldPossibleValueDao.load(Long.valueOf(idAsString), new Relationship[0]);
                                if (!possibleValue.getField().equals(field)) {
                                    throw new Exception();
                                }
                                possibleValues.add(possibleValue);
                            }
                            byName = false;
                            hql.append(" and ").append(alias).append(".possibleValue in (:").append(valueParam).append(')');
                            namedParameters.put(valueParam, possibleValues);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!byName) continue block8;
                    hql.append(" and ").append(alias).append(".possibleValue.value = :").append(valueParam);
                    namedParameters.put(valueParam, value);
                    continue block8;
                }
                case MEMBER: {
                    Long memberId = null;
                    memberId = customFieldValue.getMemberValue() != null ? customFieldValue.getMemberValue().getId() : IdConverter.instance().valueOf(value);
                    if (memberId == null) continue block8;
                    hql.append(" and ").append(alias).append(".memberValue.id = :").append(valueParam);
                    namedParameters.put(valueParam, memberId);
                    continue block8;
                }
            }
            hql.append(" and ").append(alias).append(".stringValue = :").append(valueParam);
            namedParameters.put(valueParam, value);
        }
    }

    public void appendJoins(StringBuilder hql, String fieldValuesPath, Collection<? extends CustomFieldValue> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        for (CustomFieldValue customFieldValue : values) {
            CustomField field = customFieldValue.getField();
            if (field == null) continue;
            String value = customFieldValue.getValue();
            if ((value = StringUtils.trimToNull((String)StringUtils.replace((String)value, (String)"%", (String)""))) == null) continue;
            field = this.fetchDao.fetch(field, new Relationship[0]);
            hql.append(" inner join ").append(fieldValuesPath).append(' ').append(this.alias(field));
        }
    }

    public void setCustomFieldPossibleValueDao(CustomFieldPossibleValueDAO customFieldPossibleValueDao) {
        this.customFieldPossibleValueDao = customFieldPossibleValueDao;
    }

    public void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    private String alias(CustomField field) {
        return "fv_" + field.getId();
    }
}

